@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectIssueArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Project("foo", {
 *     name: "example project",
 *     description: "Lorem Ipsum",
 *     visibilityLevel: "public",
 * });
 * const welcomeIssue = new gitlab.ProjectIssue("welcome_issue", {
 *     project: foo.id,
 *     title: "Welcome!",
 *     description: pulumi.interpolate`  Welcome to the ${foo.name} project!
 * `,
 *     discussionLocked: true,
 * });
 * export const welcomeIssueWebUrl = webUrl;
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Project("foo",
 *     name="example project",
 *     description="Lorem Ipsum",
 *     visibility_level="public")
 * welcome_issue = gitlab.ProjectIssue("welcome_issue",
 *     project=foo.id,
 *     title="Welcome!",
 *     description=foo.name.apply(lambda name: f"""  Welcome to the {name} project!
 * """),
 *     discussion_locked=True)
 * pulumi.export("welcomeIssueWebUrl", web_url)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Project("foo", new()
 *     {
 *         Name = "example project",
 *         Description = "Lorem Ipsum",
 *         VisibilityLevel = "public",
 *     });
 *     var welcomeIssue = new GitLab.ProjectIssue("welcome_issue", new()
 *     {
 *         Project = foo.Id,
 *         Title = "Welcome!",
 *         Description = foo.Name.Apply(name => @$"  Welcome to the {name} project!
 * "),
 *         DiscussionLocked = true,
 *     });
 *     return new Dictionary<string, object?>
 *     {
 *         ["welcomeIssueWebUrl"] = webUrl,
 *     };
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewProject(ctx, "foo", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("example project"),
 * 			Description:     pulumi.String("Lorem Ipsum"),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectIssue(ctx, "welcome_issue", &gitlab.ProjectIssueArgs{
 * 			Project: foo.ID(),
 * 			Title:   pulumi.String("Welcome!"),
 * 			Description: foo.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("  Welcome to the %v project!\n\n", name), nil
 * 			}).(pulumi.StringOutput),
 * 			DiscussionLocked: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ctx.Export("welcomeIssueWebUrl", webUrl)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectIssue;
 * import com.pulumi.gitlab.ProjectIssueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Project("foo", ProjectArgs.builder()
 *             .name("example project")
 *             .description("Lorem Ipsum")
 *             .visibilityLevel("public")
 *             .build());
 *         var welcomeIssue = new ProjectIssue("welcomeIssue", ProjectIssueArgs.builder()
 *             .project(foo.id())
 *             .title("Welcome!")
 *             .description(foo.name().applyValue(name -> """
 *   Welcome to the %s project!
 * ", name)))
 *             .discussionLocked(true)
 *             .build());
 *         ctx.export("welcomeIssueWebUrl", webUrl);
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Project
 *     properties:
 *       name: example project
 *       description: Lorem Ipsum
 *       visibilityLevel: public
 *   welcomeIssue:
 *     type: gitlab:ProjectIssue
 *     name: welcome_issue
 *     properties:
 *       project: ${foo.id}
 *       title: Welcome!
 *       description: |2+
 *           Welcome to the ${foo.name} project!
 *       discussionLocked: true
 * outputs:
 *   welcomeIssueWebUrl: ${webUrl}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import this resource with an id made up of `{project-id}:{issue-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectIssue:ProjectIssue welcome_issue 42:1
 * ```
 * @property assigneeIds The IDs of the users to assign the issue to.
 * @property confidential Set an issue to be confidential.
 * @property createdAt When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
 * @property deleteOnDestroy Whether the issue is deleted instead of closed during destroy.
 * @property description The description of an issue. Limited to 1,048,576 characters.
 * @property discussionLocked Whether the issue is locked for discussions or not.
 * @property discussionToResolve The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
 * @property dueDate The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
 * @property epicIssueId The ID of the epic issue.
 * @property iid The internal ID of the project's issue.
 * @property issueType The type of issue. Valid values are: `issue`, `incident`, `test_case`.
 * @property labels The labels of an issue.
 * @property mergeRequestToResolveDiscussionsOf The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
 * @property milestoneId The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
 * @property project The name or ID of the project.
 * @property state The state of the issue. Valid values are: `opened`, `closed`.
 * @property title The title of the issue.
 * @property updatedAt When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
 * @property weight The weight of the issue. Valid values are greater than or equal to 0.
 */
public data class ProjectIssueArgs(
    public val assigneeIds: Output<List<Int>>? = null,
    public val confidential: Output<Boolean>? = null,
    public val createdAt: Output<String>? = null,
    public val deleteOnDestroy: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val discussionLocked: Output<Boolean>? = null,
    public val discussionToResolve: Output<String>? = null,
    public val dueDate: Output<String>? = null,
    public val epicIssueId: Output<Int>? = null,
    public val iid: Output<Int>? = null,
    public val issueType: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val mergeRequestToResolveDiscussionsOf: Output<Int>? = null,
    public val milestoneId: Output<Int>? = null,
    public val project: Output<String>? = null,
    public val state: Output<String>? = null,
    public val title: Output<String>? = null,
    public val updatedAt: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectIssueArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectIssueArgs =
        com.pulumi.gitlab.ProjectIssueArgs.builder()
            .assigneeIds(assigneeIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .confidential(confidential?.applyValue({ args0 -> args0 }))
            .createdAt(createdAt?.applyValue({ args0 -> args0 }))
            .deleteOnDestroy(deleteOnDestroy?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .discussionLocked(discussionLocked?.applyValue({ args0 -> args0 }))
            .discussionToResolve(discussionToResolve?.applyValue({ args0 -> args0 }))
            .dueDate(dueDate?.applyValue({ args0 -> args0 }))
            .epicIssueId(epicIssueId?.applyValue({ args0 -> args0 }))
            .iid(iid?.applyValue({ args0 -> args0 }))
            .issueType(issueType?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mergeRequestToResolveDiscussionsOf(
                mergeRequestToResolveDiscussionsOf?.applyValue({ args0 ->
                    args0
                }),
            )
            .milestoneId(milestoneId?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .updatedAt(updatedAt?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectIssueArgs].
 */
@PulumiTagMarker
public class ProjectIssueArgsBuilder internal constructor() {
    private var assigneeIds: Output<List<Int>>? = null

    private var confidential: Output<Boolean>? = null

    private var createdAt: Output<String>? = null

    private var deleteOnDestroy: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var discussionLocked: Output<Boolean>? = null

    private var discussionToResolve: Output<String>? = null

    private var dueDate: Output<String>? = null

    private var epicIssueId: Output<Int>? = null

    private var iid: Output<Int>? = null

    private var issueType: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var mergeRequestToResolveDiscussionsOf: Output<Int>? = null

    private var milestoneId: Output<Int>? = null

    private var project: Output<String>? = null

    private var state: Output<String>? = null

    private var title: Output<String>? = null

    private var updatedAt: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The IDs of the users to assign the issue to.
     */
    @JvmName("ytoycuygqxtddhnv")
    public suspend fun assigneeIds(`value`: Output<List<Int>>) {
        this.assigneeIds = value
    }

    @JvmName("pugmvybuxcbwnnua")
    public suspend fun assigneeIds(vararg values: Output<Int>) {
        this.assigneeIds = Output.all(values.asList())
    }

    /**
     * @param values The IDs of the users to assign the issue to.
     */
    @JvmName("oxourfqasqgxypqk")
    public suspend fun assigneeIds(values: List<Output<Int>>) {
        this.assigneeIds = Output.all(values)
    }

    /**
     * @param value Set an issue to be confidential.
     */
    @JvmName("jypgnyyproylfhoa")
    public suspend fun confidential(`value`: Output<Boolean>) {
        this.confidential = value
    }

    /**
     * @param value When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
     */
    @JvmName("rxpbuynwfyneacxq")
    public suspend fun createdAt(`value`: Output<String>) {
        this.createdAt = value
    }

    /**
     * @param value Whether the issue is deleted instead of closed during destroy.
     */
    @JvmName("pohdpebrntyvylnn")
    public suspend fun deleteOnDestroy(`value`: Output<Boolean>) {
        this.deleteOnDestroy = value
    }

    /**
     * @param value The description of an issue. Limited to 1,048,576 characters.
     */
    @JvmName("gqvxdenkxfoeexqg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the issue is locked for discussions or not.
     */
    @JvmName("ujdbfsrspffkjbvi")
    public suspend fun discussionLocked(`value`: Output<Boolean>) {
        this.discussionLocked = value
    }

    /**
     * @param value The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
     */
    @JvmName("oqnholjqmgoqdexs")
    public suspend fun discussionToResolve(`value`: Output<String>) {
        this.discussionToResolve = value
    }

    /**
     * @param value The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
     */
    @JvmName("hbjnmdilwqrcbsov")
    public suspend fun dueDate(`value`: Output<String>) {
        this.dueDate = value
    }

    /**
     * @param value The ID of the epic issue.
     */
    @JvmName("odgnjyicvtlgdnfa")
    public suspend fun epicIssueId(`value`: Output<Int>) {
        this.epicIssueId = value
    }

    /**
     * @param value The internal ID of the project's issue.
     */
    @JvmName("vetyqrfxbdxmkuad")
    public suspend fun iid(`value`: Output<Int>) {
        this.iid = value
    }

    /**
     * @param value The type of issue. Valid values are: `issue`, `incident`, `test_case`.
     */
    @JvmName("htitqlwehjnhdqwb")
    public suspend fun issueType(`value`: Output<String>) {
        this.issueType = value
    }

    /**
     * @param value The labels of an issue.
     */
    @JvmName("laooqjxiwgkldcbn")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("wntryhtbflrsenaa")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The labels of an issue.
     */
    @JvmName("mwengcwsyavohmby")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
     */
    @JvmName("biaamgtlswajxxlm")
    public suspend fun mergeRequestToResolveDiscussionsOf(`value`: Output<Int>) {
        this.mergeRequestToResolveDiscussionsOf = value
    }

    /**
     * @param value The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
     */
    @JvmName("txbxhrjfamwjgyuh")
    public suspend fun milestoneId(`value`: Output<Int>) {
        this.milestoneId = value
    }

    /**
     * @param value The name or ID of the project.
     */
    @JvmName("bktfojgbpvqscfuo")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The state of the issue. Valid values are: `opened`, `closed`.
     */
    @JvmName("bsuwvjmphhdyvobx")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The title of the issue.
     */
    @JvmName("cnvaejyglwjltnoq")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    @JvmName("paofyiefbxodmmty")
    public suspend fun updatedAt(`value`: Output<String>) {
        this.updatedAt = value
    }

    /**
     * @param value The weight of the issue. Valid values are greater than or equal to 0.
     */
    @JvmName("lsildctfoniffhlm")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The IDs of the users to assign the issue to.
     */
    @JvmName("esljojxpxritdrcf")
    public suspend fun assigneeIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assigneeIds = mapped
    }

    /**
     * @param values The IDs of the users to assign the issue to.
     */
    @JvmName("dllodrogiannbjmp")
    public suspend fun assigneeIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assigneeIds = mapped
    }

    /**
     * @param value Set an issue to be confidential.
     */
    @JvmName("ldwrfcwrairufpad")
    public suspend fun confidential(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidential = mapped
    }

    /**
     * @param value When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
     */
    @JvmName("fhoxufnxvyruyion")
    public suspend fun createdAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdAt = mapped
    }

    /**
     * @param value Whether the issue is deleted instead of closed during destroy.
     */
    @JvmName("tmkexhpidsyavdyw")
    public suspend fun deleteOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnDestroy = mapped
    }

    /**
     * @param value The description of an issue. Limited to 1,048,576 characters.
     */
    @JvmName("jqifwoolwgrvlqmb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the issue is locked for discussions or not.
     */
    @JvmName("ugrgpnbrmlcjwvdm")
    public suspend fun discussionLocked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discussionLocked = mapped
    }

    /**
     * @param value The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
     */
    @JvmName("naeignsnaqqivotq")
    public suspend fun discussionToResolve(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discussionToResolve = mapped
    }

    /**
     * @param value The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
     */
    @JvmName("gcqtnyhhgoxslfli")
    public suspend fun dueDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dueDate = mapped
    }

    /**
     * @param value The ID of the epic issue.
     */
    @JvmName("wucixtqnvupohsty")
    public suspend fun epicIssueId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.epicIssueId = mapped
    }

    /**
     * @param value The internal ID of the project's issue.
     */
    @JvmName("krbhwfovywvwpdux")
    public suspend fun iid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iid = mapped
    }

    /**
     * @param value The type of issue. Valid values are: `issue`, `incident`, `test_case`.
     */
    @JvmName("xedfqgiwkryxvndb")
    public suspend fun issueType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueType = mapped
    }

    /**
     * @param value The labels of an issue.
     */
    @JvmName("eialcjoerclgthoh")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values The labels of an issue.
     */
    @JvmName("krvgjefmylvlmuiu")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
     */
    @JvmName("ahjhsjqehyxasadl")
    public suspend fun mergeRequestToResolveDiscussionsOf(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestToResolveDiscussionsOf = mapped
    }

    /**
     * @param value The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
     */
    @JvmName("arumhwtfenggstsc")
    public suspend fun milestoneId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.milestoneId = mapped
    }

    /**
     * @param value The name or ID of the project.
     */
    @JvmName("dnsbinjlghyqvwtg")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The state of the issue. Valid values are: `opened`, `closed`.
     */
    @JvmName("igcndduehwrhrucv")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The title of the issue.
     */
    @JvmName("gjxrtvugedtiqmow")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    @JvmName("fieyljjooiaqtdrh")
    public suspend fun updatedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updatedAt = mapped
    }

    /**
     * @param value The weight of the issue. Valid values are greater than or equal to 0.
     */
    @JvmName("hvsgyohddwfwcqsk")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ProjectIssueArgs = ProjectIssueArgs(
        assigneeIds = assigneeIds,
        confidential = confidential,
        createdAt = createdAt,
        deleteOnDestroy = deleteOnDestroy,
        description = description,
        discussionLocked = discussionLocked,
        discussionToResolve = discussionToResolve,
        dueDate = dueDate,
        epicIssueId = epicIssueId,
        iid = iid,
        issueType = issueType,
        labels = labels,
        mergeRequestToResolveDiscussionsOf = mergeRequestToResolveDiscussionsOf,
        milestoneId = milestoneId,
        project = project,
        state = state,
        title = title,
        updatedAt = updatedAt,
        weight = weight,
    )
}
