@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ProjectIssueBoardList
import com.pulumi.gitlab.kotlin.outputs.ProjectIssueBoardList.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ProjectIssueBoard].
 */
@PulumiTagMarker
public class ProjectIssueBoardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectIssueBoardArgs = ProjectIssueBoardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectIssueBoardArgsBuilder.() -> Unit) {
        val builder = ProjectIssueBoardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectIssueBoard {
        val builtJavaResource = com.pulumi.gitlab.ProjectIssueBoard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectIssueBoard(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectIssueBoard` resource allows to manage the lifecycle of a Project Issue Board.
 * > **NOTE:** If the board lists are changed all lists will be recreated.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/boards.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example project
 *       description: Lorem Ipsum
 *       visibilityLevel: public
 *   exampleUser:
 *     type: gitlab:User
 *     name: example
 *     properties:
 *       name: example
 *       username: example
 *       email: example@example.com
 *       password: example1$$$
 *   exampleProjectMembership:
 *     type: gitlab:ProjectMembership
 *     name: example
 *     properties:
 *       projectId: ${example.id}
 *       userId: ${exampleUser.id}
 *       accessLevel: developer
 *   exampleProjectMilestone:
 *     type: gitlab:ProjectMilestone
 *     name: example
 *     properties:
 *       project: ${example.id}
 *       title: m1
 *   this:
 *     type: gitlab:ProjectIssueBoard
 *     properties:
 *       project: ${example.id}
 *       name: Test Issue Board
 *       lists:
 *         - assigneeId: ${exampleUser.id}
 *         - milestoneId: ${exampleProjectMilestone.milestoneId}
 *     options:
 *       dependson:
 *         - ${exampleProjectMembership}
 *   listSyntax:
 *     type: gitlab:ProjectIssueBoard
 *     name: list_syntax
 *     properties:
 *       project: ${example.id}
 *       name: Test Issue Board with list syntax
 *       lists:
 *         - assigneeId: ${exampleUser.id}
 *         - milestoneId: ${exampleProjectMilestone.milestoneId}
 *     options:
 *       dependson:
 *         - ${exampleProjectMembership}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import this resource with an id made up of `{project-id}:{issue-board-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectIssueBoard:ProjectIssueBoard kanban 42:1
 * ```
 */
public class ProjectIssueBoard internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectIssueBoard,
) : KotlinCustomResource(javaResource, ProjectIssueBoardMapper) {
    /**
     * The assignee the board should be scoped to. Requires a GitLab EE license.
     */
    public val assigneeId: Output<Int>?
        get() = javaResource.assigneeId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of label names which the board should be scoped to. Requires a GitLab EE license.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The list of issue board lists
     */
    public val lists: Output<List<ProjectIssueBoardList>>?
        get() = javaResource.lists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The milestone the board should be scoped to. Requires a GitLab EE license.
     */
    public val milestoneId: Output<Int>?
        get() = javaResource.milestoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the board.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project maintained by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
     */
    public val weight: Output<Int>?
        get() = javaResource.weight().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ProjectIssueBoardMapper : ResourceMapper<ProjectIssueBoard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectIssueBoard::class == javaResource::class

    override fun map(javaResource: Resource): ProjectIssueBoard = ProjectIssueBoard(
        javaResource as
            com.pulumi.gitlab.ProjectIssueBoard,
    )
}

/**
 * @see [ProjectIssueBoard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectIssueBoard].
 */
public suspend fun projectIssueBoard(
    name: String,
    block: suspend ProjectIssueBoardResourceBuilder.() -> Unit,
): ProjectIssueBoard {
    val builder = ProjectIssueBoardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectIssueBoard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectIssueBoard(name: String): ProjectIssueBoard {
    val builder = ProjectIssueBoardResourceBuilder()
    builder.name(name)
    return builder.build()
}
