@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectIssueBoardArgs.builder
import com.pulumi.gitlab.kotlin.inputs.ProjectIssueBoardListArgs
import com.pulumi.gitlab.kotlin.inputs.ProjectIssueBoardListArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectIssueBoard` resource allows to manage the lifecycle of a Project Issue Board.
 * > **NOTE:** If the board lists are changed all lists will be recreated.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/boards.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example project
 *       description: Lorem Ipsum
 *       visibilityLevel: public
 *   exampleUser:
 *     type: gitlab:User
 *     name: example
 *     properties:
 *       name: example
 *       username: example
 *       email: example@example.com
 *       password: example1$$$
 *   exampleProjectMembership:
 *     type: gitlab:ProjectMembership
 *     name: example
 *     properties:
 *       projectId: ${example.id}
 *       userId: ${exampleUser.id}
 *       accessLevel: developer
 *   exampleProjectMilestone:
 *     type: gitlab:ProjectMilestone
 *     name: example
 *     properties:
 *       project: ${example.id}
 *       title: m1
 *   this:
 *     type: gitlab:ProjectIssueBoard
 *     properties:
 *       project: ${example.id}
 *       name: Test Issue Board
 *       lists:
 *         - assigneeId: ${exampleUser.id}
 *         - milestoneId: ${exampleProjectMilestone.milestoneId}
 *     options:
 *       dependson:
 *         - ${exampleProjectMembership}
 *   listSyntax:
 *     type: gitlab:ProjectIssueBoard
 *     name: list_syntax
 *     properties:
 *       project: ${example.id}
 *       name: Test Issue Board with list syntax
 *       lists:
 *         - assigneeId: ${exampleUser.id}
 *         - milestoneId: ${exampleProjectMilestone.milestoneId}
 *     options:
 *       dependson:
 *         - ${exampleProjectMembership}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import this resource with an id made up of `{project-id}:{issue-board-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectIssueBoard:ProjectIssueBoard kanban 42:1
 * ```
 * @property assigneeId The assignee the board should be scoped to. Requires a GitLab EE license.
 * @property labels The list of label names which the board should be scoped to. Requires a GitLab EE license.
 * @property lists The list of issue board lists
 * @property milestoneId The milestone the board should be scoped to. Requires a GitLab EE license.
 * @property name The name of the board.
 * @property project The ID or full path of the project maintained by the authenticated user.
 * @property weight The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
 */
public data class ProjectIssueBoardArgs(
    public val assigneeId: Output<Int>? = null,
    public val labels: Output<List<String>>? = null,
    public val lists: Output<List<ProjectIssueBoardListArgs>>? = null,
    public val milestoneId: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectIssueBoardArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectIssueBoardArgs =
        com.pulumi.gitlab.ProjectIssueBoardArgs.builder()
            .assigneeId(assigneeId?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .lists(lists?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .milestoneId(milestoneId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectIssueBoardArgs].
 */
@PulumiTagMarker
public class ProjectIssueBoardArgsBuilder internal constructor() {
    private var assigneeId: Output<Int>? = null

    private var labels: Output<List<String>>? = null

    private var lists: Output<List<ProjectIssueBoardListArgs>>? = null

    private var milestoneId: Output<Int>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value The assignee the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("ehivhbtbjqleyydy")
    public suspend fun assigneeId(`value`: Output<Int>) {
        this.assigneeId = value
    }

    /**
     * @param value The list of label names which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("flvvgrethoyhmkle")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("nfwfnnanklpdufos")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The list of label names which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("anjmdcpncyudftkb")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The list of issue board lists
     */
    @JvmName("pemqecfishiowket")
    public suspend fun lists(`value`: Output<List<ProjectIssueBoardListArgs>>) {
        this.lists = value
    }

    @JvmName("xvmwjnlwkpeinkcs")
    public suspend fun lists(vararg values: Output<ProjectIssueBoardListArgs>) {
        this.lists = Output.all(values.asList())
    }

    /**
     * @param values The list of issue board lists
     */
    @JvmName("upjibqeihqmjopml")
    public suspend fun lists(values: List<Output<ProjectIssueBoardListArgs>>) {
        this.lists = Output.all(values)
    }

    /**
     * @param value The milestone the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("wvhyrwevepyhvvbb")
    public suspend fun milestoneId(`value`: Output<Int>) {
        this.milestoneId = value
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("ndwitspiqlwyqult")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID or full path of the project maintained by the authenticated user.
     */
    @JvmName("mhwkpxblwviwdtvu")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("hoawlubjauvlmwpo")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value The assignee the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("fvaosxccgkoafaxf")
    public suspend fun assigneeId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assigneeId = mapped
    }

    /**
     * @param value The list of label names which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("eocyfxlmdemvyopn")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values The list of label names which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("sxmdlsbfvtenkyul")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The list of issue board lists
     */
    @JvmName("aedqwgpgeucifmax")
    public suspend fun lists(`value`: List<ProjectIssueBoardListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists
     */
    @JvmName("frxjoivkxmspdvdu")
    public suspend fun lists(argument: List<suspend ProjectIssueBoardListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectIssueBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists
     */
    @JvmName("rmcbolsgmcdrkvbb")
    public suspend fun lists(vararg argument: suspend ProjectIssueBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectIssueBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists
     */
    @JvmName("pcrblokbssmpvklp")
    public suspend fun lists(argument: suspend ProjectIssueBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProjectIssueBoardListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param values The list of issue board lists
     */
    @JvmName("biauwqxydooexkuq")
    public suspend fun lists(vararg values: ProjectIssueBoardListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param value The milestone the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("yuwxtqfyfemflqih")
    public suspend fun milestoneId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.milestoneId = mapped
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("rkdgqakscnvyhgpy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID or full path of the project maintained by the authenticated user.
     */
    @JvmName("ngkfteqldwjrhfup")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The weight range from 0 to 9, to which the board should be scoped to. Requires a GitLab EE license.
     */
    @JvmName("ckiqpseioiiukhwt")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): ProjectIssueBoardArgs = ProjectIssueBoardArgs(
        assigneeId = assigneeId,
        labels = labels,
        lists = lists,
        milestoneId = milestoneId,
        name = name,
        project = project,
        weight = weight,
    )
}
