@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectJobTokenScope].
 */
@PulumiTagMarker
public class ProjectJobTokenScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectJobTokenScopeArgs = ProjectJobTokenScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectJobTokenScopeArgsBuilder.() -> Unit) {
        val builder = ProjectJobTokenScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectJobTokenScope {
        val builtJavaResource = com.pulumi.gitlab.ProjectJobTokenScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectJobTokenScope(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectJobTokenScope` resource allows to manage the CI/CD Job Token scope in a project.
 * Any projects added to the CI/CD Job Token scope outside of TF will be untouched by the resource.
 * > Conflicts with the use of `gitlab.ProjectJobTokenScopes` when used on the same project. Use one or the other to ensure the desired state.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_job_token_scopes.html)
 * ## Import
 * GitLab project job token scopes can be imported using an id made up of `projectId:targetProjectId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectJobTokenScope:ProjectJobTokenScope bar 123:321
 * ```
 */
public class ProjectJobTokenScope internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectJobTokenScope,
) : KotlinCustomResource(javaResource, ProjectJobTokenScopeMapper) {
    /**
     * The ID or full path of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The ID of the project that is in the CI/CD job token inbound allowlist.
     */
    public val targetProjectId: Output<Int>
        get() = javaResource.targetProjectId().applyValue({ args0 -> args0 })
}

public object ProjectJobTokenScopeMapper : ResourceMapper<ProjectJobTokenScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectJobTokenScope::class == javaResource::class

    override fun map(javaResource: Resource): ProjectJobTokenScope = ProjectJobTokenScope(
        javaResource
            as com.pulumi.gitlab.ProjectJobTokenScope,
    )
}

/**
 * @see [ProjectJobTokenScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectJobTokenScope].
 */
public suspend fun projectJobTokenScope(
    name: String,
    block: suspend ProjectJobTokenScopeResourceBuilder.() -> Unit,
): ProjectJobTokenScope {
    val builder = ProjectJobTokenScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectJobTokenScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectJobTokenScope(name: String): ProjectJobTokenScope {
    val builder = ProjectJobTokenScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
