@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectJobTokenScopeArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectJobTokenScope` resource allows to manage the CI/CD Job Token scope in a project.
 * Any projects added to the CI/CD Job Token scope outside of TF will be untouched by the resource.
 * > Conflicts with the use of `gitlab.ProjectJobTokenScopes` when used on the same project. Use one or the other to ensure the desired state.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_job_token_scopes.html)
 * ## Import
 * GitLab project job token scopes can be imported using an id made up of `projectId:targetProjectId`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectJobTokenScope:ProjectJobTokenScope bar 123:321
 * ```
 * @property project The ID or full path of the project.
 * @property targetProjectId The ID of the project that is in the CI/CD job token inbound allowlist.
 */
public data class ProjectJobTokenScopeArgs(
    public val project: Output<String>? = null,
    public val targetProjectId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectJobTokenScopeArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectJobTokenScopeArgs =
        com.pulumi.gitlab.ProjectJobTokenScopeArgs.builder()
            .project(project?.applyValue({ args0 -> args0 }))
            .targetProjectId(targetProjectId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectJobTokenScopeArgs].
 */
@PulumiTagMarker
public class ProjectJobTokenScopeArgsBuilder internal constructor() {
    private var project: Output<String>? = null

    private var targetProjectId: Output<Int>? = null

    /**
     * @param value The ID or full path of the project.
     */
    @JvmName("saytrrlxkgjgsssl")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The ID of the project that is in the CI/CD job token inbound allowlist.
     */
    @JvmName("emgqwwaapinpqhdp")
    public suspend fun targetProjectId(`value`: Output<Int>) {
        this.targetProjectId = value
    }

    /**
     * @param value The ID or full path of the project.
     */
    @JvmName("arceqejyuuqldaep")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The ID of the project that is in the CI/CD job token inbound allowlist.
     */
    @JvmName("befqnndwbiwedodl")
    public suspend fun targetProjectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProjectId = mapped
    }

    internal fun build(): ProjectJobTokenScopeArgs = ProjectJobTokenScopeArgs(
        project = project,
        targetProjectId = targetProjectId,
    )
}
