@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectJobTokenScopesArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectJobTokenScopes` resource allows to manage the CI/CD Job Token scopes in a project.
 * Any project not within the defined set in this attribute will be removed, which allows this resource to be used as an explicit deny.
 * > Conflicts with the use of `gitlab.ProjectJobTokenScope` when used on the same project. Use one or the other to ensure the desired state.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_job_token_scopes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const allowedSingleProject = new gitlab.ProjectJobTokenScopes("allowed_single_project", {
 *     project: "111",
 *     targetProjectIds: [123],
 * });
 * const allowedMultipleProject = new gitlab.ProjectJobTokenScopes("allowed_multiple_project", {
 *     project: "111",
 *     targetProjectIds: [
 *         123,
 *         456,
 *         789,
 *     ],
 * });
 * const allowedMultipleGroups = new gitlab.ProjectJobTokenScopes("allowed_multiple_groups", {
 *     projectId: 111,
 *     targetProjectIds: [],
 *     targetGroupIds: [
 *         321,
 *         654,
 *     ],
 * });
 * // This will remove all job token scopes, even if added outside of TF.
 * const explicitDeny = new gitlab.ProjectJobTokenScopes("explicit_deny", {
 *     project: "111",
 *     targetProjectIds: [],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * allowed_single_project = gitlab.ProjectJobTokenScopes("allowed_single_project",
 *     project="111",
 *     target_project_ids=[123])
 * allowed_multiple_project = gitlab.ProjectJobTokenScopes("allowed_multiple_project",
 *     project="111",
 *     target_project_ids=[
 *         123,
 *         456,
 *         789,
 *     ])
 * allowed_multiple_groups = gitlab.ProjectJobTokenScopes("allowed_multiple_groups",
 *     project_id=111,
 *     target_project_ids=[],
 *     target_group_ids=[
 *         321,
 *         654,
 *     ])
 * # This will remove all job token scopes, even if added outside of TF.
 * explicit_deny = gitlab.ProjectJobTokenScopes("explicit_deny",
 *     project="111",
 *     target_project_ids=[])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var allowedSingleProject = new GitLab.ProjectJobTokenScopes("allowed_single_project", new()
 *     {
 *         Project = "111",
 *         TargetProjectIds = new[]
 *         {
 *             123,
 *         },
 *     });
 *     var allowedMultipleProject = new GitLab.ProjectJobTokenScopes("allowed_multiple_project", new()
 *     {
 *         Project = "111",
 *         TargetProjectIds = new[]
 *         {
 *             123,
 *             456,
 *             789,
 *         },
 *     });
 *     var allowedMultipleGroups = new GitLab.ProjectJobTokenScopes("allowed_multiple_groups", new()
 *     {
 *         ProjectId = 111,
 *         TargetProjectIds = new[] {},
 *         TargetGroupIds = new[]
 *         {
 *             321,
 *             654,
 *         },
 *     });
 *     // This will remove all job token scopes, even if added outside of TF.
 *     var explicitDeny = new GitLab.ProjectJobTokenScopes("explicit_deny", new()
 *     {
 *         Project = "111",
 *         TargetProjectIds = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectJobTokenScopes(ctx, "allowed_single_project", &gitlab.ProjectJobTokenScopesArgs{
 * 			Project: pulumi.String("111"),
 * 			TargetProjectIds: pulumi.IntArray{
 * 				pulumi.Int(123),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectJobTokenScopes(ctx, "allowed_multiple_project", &gitlab.ProjectJobTokenScopesArgs{
 * 			Project: pulumi.String("111"),
 * 			TargetProjectIds: pulumi.IntArray{
 * 				pulumi.Int(123),
 * 				pulumi.Int(456),
 * 				pulumi.Int(789),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectJobTokenScopes(ctx, "allowed_multiple_groups", &gitlab.ProjectJobTokenScopesArgs{
 * 			ProjectId:        pulumi.Int(111),
 * 			TargetProjectIds: pulumi.IntArray{},
 * 			TargetGroupIds: pulumi.IntArray{
 * 				pulumi.Int(321),
 * 				pulumi.Int(654),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// This will remove all job token scopes, even if added outside of TF.
 * 		_, err = gitlab.NewProjectJobTokenScopes(ctx, "explicit_deny", &gitlab.ProjectJobTokenScopesArgs{
 * 			Project:          pulumi.String("111"),
 * 			TargetProjectIds: pulumi.IntArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectJobTokenScopes;
 * import com.pulumi.gitlab.ProjectJobTokenScopesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var allowedSingleProject = new ProjectJobTokenScopes("allowedSingleProject", ProjectJobTokenScopesArgs.builder()
 *             .project("111")
 *             .targetProjectIds(123)
 *             .build());
 *         var allowedMultipleProject = new ProjectJobTokenScopes("allowedMultipleProject", ProjectJobTokenScopesArgs.builder()
 *             .project("111")
 *             .targetProjectIds(
 *                 123,
 *                 456,
 *                 789)
 *             .build());
 *         var allowedMultipleGroups = new ProjectJobTokenScopes("allowedMultipleGroups", ProjectJobTokenScopesArgs.builder()
 *             .projectId(111)
 *             .targetProjectIds()
 *             .targetGroupIds(
 *                 321,
 *                 654)
 *             .build());
 *         // This will remove all job token scopes, even if added outside of TF.
 *         var explicitDeny = new ProjectJobTokenScopes("explicitDeny", ProjectJobTokenScopesArgs.builder()
 *             .project("111")
 *             .targetProjectIds()
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   allowedSingleProject:
 *     type: gitlab:ProjectJobTokenScopes
 *     name: allowed_single_project
 *     properties:
 *       project: '111'
 *       targetProjectIds:
 *         - 123
 *   allowedMultipleProject:
 *     type: gitlab:ProjectJobTokenScopes
 *     name: allowed_multiple_project
 *     properties:
 *       project: '111'
 *       targetProjectIds:
 *         - 123
 *         - 456
 *         - 789
 *   allowedMultipleGroups:
 *     type: gitlab:ProjectJobTokenScopes
 *     name: allowed_multiple_groups
 *     properties:
 *       projectId: 111
 *       targetProjectIds: []
 *       targetGroupIds:
 *         - 321
 *         - 654
 *   # This will remove all job token scopes, even if added outside of TF.
 *   explicitDeny:
 *     type: gitlab:ProjectJobTokenScopes
 *     name: explicit_deny
 *     properties:
 *       project: '111'
 *       targetProjectIds: []
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project job token scopes can be imported using an id made up of just the `project_id`
 * ```sh
 * $ pulumi import gitlab:index/projectJobTokenScopes:ProjectJobTokenScopes bar 123
 * ```
 * @property project The ID or full path of the project.
 * @property projectId The ID of the project.
 * @property targetGroupIds A set of group IDs that are in the CI/CD job token inbound allowlist.
 * @property targetProjectIds A set of project IDs that are in the CI/CD job token inbound allowlist.
 */
public data class ProjectJobTokenScopesArgs(
    public val project: Output<String>? = null,
    @Deprecated(
        message = """
  `project_id` has been deprecated. Use `project` instead.
  """,
    )
    public val projectId: Output<Int>? = null,
    public val targetGroupIds: Output<List<Int>>? = null,
    public val targetProjectIds: Output<List<Int>>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectJobTokenScopesArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectJobTokenScopesArgs =
        com.pulumi.gitlab.ProjectJobTokenScopesArgs.builder()
            .project(project?.applyValue({ args0 -> args0 }))
            .projectId(projectId?.applyValue({ args0 -> args0 }))
            .targetGroupIds(targetGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetProjectIds(targetProjectIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProjectJobTokenScopesArgs].
 */
@PulumiTagMarker
public class ProjectJobTokenScopesArgsBuilder internal constructor() {
    private var project: Output<String>? = null

    private var projectId: Output<Int>? = null

    private var targetGroupIds: Output<List<Int>>? = null

    private var targetProjectIds: Output<List<Int>>? = null

    /**
     * @param value The ID or full path of the project.
     */
    @JvmName("qqfspqcpmjxuuvet")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The ID of the project.
     */
    @Deprecated(
        message = """
  `project_id` has been deprecated. Use `project` instead.
  """,
    )
    @JvmName("slnctijgmqxcseab")
    public suspend fun projectId(`value`: Output<Int>) {
        this.projectId = value
    }

    /**
     * @param value A set of group IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("vngmqlrchmqkhspb")
    public suspend fun targetGroupIds(`value`: Output<List<Int>>) {
        this.targetGroupIds = value
    }

    @JvmName("hlrgdybdhpeefrhj")
    public suspend fun targetGroupIds(vararg values: Output<Int>) {
        this.targetGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A set of group IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("pvanvcecfisjucin")
    public suspend fun targetGroupIds(values: List<Output<Int>>) {
        this.targetGroupIds = Output.all(values)
    }

    /**
     * @param value A set of project IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("ssmivuuhlgtrpnsg")
    public suspend fun targetProjectIds(`value`: Output<List<Int>>) {
        this.targetProjectIds = value
    }

    @JvmName("vjnrtydoqtlnviuv")
    public suspend fun targetProjectIds(vararg values: Output<Int>) {
        this.targetProjectIds = Output.all(values.asList())
    }

    /**
     * @param values A set of project IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("craruqdouiasayns")
    public suspend fun targetProjectIds(values: List<Output<Int>>) {
        this.targetProjectIds = Output.all(values)
    }

    /**
     * @param value The ID or full path of the project.
     */
    @JvmName("abhybjhujmolcgsf")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The ID of the project.
     */
    @Deprecated(
        message = """
  `project_id` has been deprecated. Use `project` instead.
  """,
    )
    @JvmName("kbfvfottdcbcqoju")
    public suspend fun projectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectId = mapped
    }

    /**
     * @param value A set of group IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("yfurbiqfmgkpxbuf")
    public suspend fun targetGroupIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupIds = mapped
    }

    /**
     * @param values A set of group IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("yertsvsfratquqyr")
    public suspend fun targetGroupIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetGroupIds = mapped
    }

    /**
     * @param value A set of project IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("oegcskwsakjouxtm")
    public suspend fun targetProjectIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProjectIds = mapped
    }

    /**
     * @param values A set of project IDs that are in the CI/CD job token inbound allowlist.
     */
    @JvmName("phttekfnrpdlaedr")
    public suspend fun targetProjectIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetProjectIds = mapped
    }

    internal fun build(): ProjectJobTokenScopesArgs = ProjectJobTokenScopesArgs(
        project = project,
        projectId = projectId,
        targetGroupIds = targetGroupIds,
        targetProjectIds = targetProjectIds,
    )
}
