@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectLabel].
 */
@PulumiTagMarker
public class ProjectLabelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectLabelArgs = ProjectLabelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectLabelArgsBuilder.() -> Unit) {
        val builder = ProjectLabelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectLabel {
        val builtJavaResource = com.pulumi.gitlab.ProjectLabel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectLabel(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectLabel` resource allows to manage the lifecycle of a project label.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/labels.html#project-labels)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const fixme = new gitlab.ProjectLabel("fixme", {
 *     project: "example",
 *     name: "fixme",
 *     description: "issue with failing tests",
 *     color: "#ffcc00",
 * });
 * // Scoped label
 * const devopsCreate = new gitlab.ProjectLabel("devops_create", {
 *     project: example.id,
 *     name: "devops::create",
 *     description: "issue for creating infrastructure resources",
 *     color: "#ffa500",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * fixme = gitlab.ProjectLabel("fixme",
 *     project="example",
 *     name="fixme",
 *     description="issue with failing tests",
 *     color="#ffcc00")
 * # Scoped label
 * devops_create = gitlab.ProjectLabel("devops_create",
 *     project=example["id"],
 *     name="devops::create",
 *     description="issue for creating infrastructure resources",
 *     color="#ffa500")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fixme = new GitLab.ProjectLabel("fixme", new()
 *     {
 *         Project = "example",
 *         Name = "fixme",
 *         Description = "issue with failing tests",
 *         Color = "#ffcc00",
 *     });
 *     // Scoped label
 *     var devopsCreate = new GitLab.ProjectLabel("devops_create", new()
 *     {
 *         Project = example.Id,
 *         Name = "devops::create",
 *         Description = "issue for creating infrastructure resources",
 *         Color = "#ffa500",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectLabel(ctx, "fixme", &gitlab.ProjectLabelArgs{
 * 			Project:     pulumi.String("example"),
 * 			Name:        pulumi.String("fixme"),
 * 			Description: pulumi.String("issue with failing tests"),
 * 			Color:       pulumi.String("#ffcc00"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Scoped label
 * 		_, err = gitlab.NewProjectLabel(ctx, "devops_create", &gitlab.ProjectLabelArgs{
 * 			Project:     pulumi.Any(example.Id),
 * 			Name:        pulumi.String("devops::create"),
 * 			Description: pulumi.String("issue for creating infrastructure resources"),
 * 			Color:       pulumi.String("#ffa500"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectLabel;
 * import com.pulumi.gitlab.ProjectLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fixme = new ProjectLabel("fixme", ProjectLabelArgs.builder()
 *             .project("example")
 *             .name("fixme")
 *             .description("issue with failing tests")
 *             .color("#ffcc00")
 *             .build());
 *         // Scoped label
 *         var devopsCreate = new ProjectLabel("devopsCreate", ProjectLabelArgs.builder()
 *             .project(example.id())
 *             .name("devops::create")
 *             .description("issue for creating infrastructure resources")
 *             .color("#ffa500")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fixme:
 *     type: gitlab:ProjectLabel
 *     properties:
 *       project: example
 *       name: fixme
 *       description: issue with failing tests
 *       color: '#ffcc00'
 *   # Scoped label
 *   devopsCreate:
 *     type: gitlab:ProjectLabel
 *     name: devops_create
 *     properties:
 *       project: ${example.id}
 *       name: devops::create
 *       description: issue for creating infrastructure resources
 *       color: '#ffa500'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab Project labels can be imported using an id made up of `{project_id}:{group_label_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectLabel:ProjectLabel example 12345:fixme
 * ```
 */
public class ProjectLabel internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectLabel,
) : KotlinCustomResource(javaResource, ProjectLabelMapper) {
    /**
     * The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    public val color: Output<String>
        get() = javaResource.color().applyValue({ args0 -> args0 })

    /**
     * The description of the label.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the project label.
     */
    public val labelId: Output<Int>
        get() = javaResource.labelId().applyValue({ args0 -> args0 })

    /**
     * The name of the label.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the label to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ProjectLabelMapper : ResourceMapper<ProjectLabel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectLabel::class == javaResource::class

    override fun map(javaResource: Resource): ProjectLabel = ProjectLabel(
        javaResource as
            com.pulumi.gitlab.ProjectLabel,
    )
}

/**
 * @see [ProjectLabel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectLabel].
 */
public suspend fun projectLabel(
    name: String,
    block: suspend ProjectLabelResourceBuilder.() -> Unit,
): ProjectLabel {
    val builder = ProjectLabelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectLabel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectLabel(name: String): ProjectLabel {
    val builder = ProjectLabelResourceBuilder()
    builder.name(name)
    return builder.build()
}
