@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectLevelMrApprovals].
 */
@PulumiTagMarker
public class ProjectLevelMrApprovalsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectLevelMrApprovalsArgs = ProjectLevelMrApprovalsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectLevelMrApprovalsArgsBuilder.() -> Unit) {
        val builder = ProjectLevelMrApprovalsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectLevelMrApprovals {
        val builtJavaResource = com.pulumi.gitlab.ProjectLevelMrApprovals(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectLevelMrApprovals(builtJavaResource)
    }
}

/**
 * The `gitlab_project_level_mr_approval_rule` resource allows to manage the lifecycle of a Merge Request-level approval rule.
 * > This resource requires a GitLab Enterprise instance.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/merge_request_approvals.html#merge-request-level-mr-approvals)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Project("foo", {
 *     name: "Example",
 *     description: "My example project",
 * });
 * const fooProjectLevelMrApprovals = new gitlab.ProjectLevelMrApprovals("foo", {
 *     project: foo.id,
 *     resetApprovalsOnPush: true,
 *     disableOverridingApproversPerMergeRequest: false,
 *     mergeRequestsAuthorApproval: false,
 *     mergeRequestsDisableCommittersApproval: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Project("foo",
 *     name="Example",
 *     description="My example project")
 * foo_project_level_mr_approvals = gitlab.ProjectLevelMrApprovals("foo",
 *     project=foo.id,
 *     reset_approvals_on_push=True,
 *     disable_overriding_approvers_per_merge_request=False,
 *     merge_requests_author_approval=False,
 *     merge_requests_disable_committers_approval=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Project("foo", new()
 *     {
 *         Name = "Example",
 *         Description = "My example project",
 *     });
 *     var fooProjectLevelMrApprovals = new GitLab.ProjectLevelMrApprovals("foo", new()
 *     {
 *         Project = foo.Id,
 *         ResetApprovalsOnPush = true,
 *         DisableOverridingApproversPerMergeRequest = false,
 *         MergeRequestsAuthorApproval = false,
 *         MergeRequestsDisableCommittersApproval = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewProject(ctx, "foo", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("Example"),
 * 			Description: pulumi.String("My example project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectLevelMrApprovals(ctx, "foo", &gitlab.ProjectLevelMrApprovalsArgs{
 * 			Project:              foo.ID(),
 * 			ResetApprovalsOnPush: pulumi.Bool(true),
 * 			DisableOverridingApproversPerMergeRequest: pulumi.Bool(false),
 * 			MergeRequestsAuthorApproval:               pulumi.Bool(false),
 * 			MergeRequestsDisableCommittersApproval:    pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectLevelMrApprovals;
 * import com.pulumi.gitlab.ProjectLevelMrApprovalsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Project("foo", ProjectArgs.builder()
 *             .name("Example")
 *             .description("My example project")
 *             .build());
 *         var fooProjectLevelMrApprovals = new ProjectLevelMrApprovals("fooProjectLevelMrApprovals", ProjectLevelMrApprovalsArgs.builder()
 *             .project(foo.id())
 *             .resetApprovalsOnPush(true)
 *             .disableOverridingApproversPerMergeRequest(false)
 *             .mergeRequestsAuthorApproval(false)
 *             .mergeRequestsDisableCommittersApproval(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Project
 *     properties:
 *       name: Example
 *       description: My example project
 *   fooProjectLevelMrApprovals:
 *     type: gitlab:ProjectLevelMrApprovals
 *     name: foo
 *     properties:
 *       project: ${foo.id}
 *       resetApprovalsOnPush: true
 *       disableOverridingApproversPerMergeRequest: false
 *       mergeRequestsAuthorApproval: false
 *       mergeRequestsDisableCommittersApproval: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/projectLevelMrApprovals:ProjectLevelMrApprovals You can import an approval configuration state using `<resource> <project_id>`.
 * ```
 * For example:
 * ```sh
 * $ pulumi import gitlab:index/projectLevelMrApprovals:ProjectLevelMrApprovals foo 1234
 * ```
 */
public class ProjectLevelMrApprovals internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectLevelMrApprovals,
) : KotlinCustomResource(javaResource, ProjectLevelMrApprovalsMapper) {
    /**
     * Set to `true` to disable overriding approvers per merge request.
     */
    public val disableOverridingApproversPerMergeRequest: Output<Boolean>
        get() = javaResource.disableOverridingApproversPerMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Set to `true` to allow merge requests authors to approve their own merge requests.
     */
    public val mergeRequestsAuthorApproval: Output<Boolean>
        get() = javaResource.mergeRequestsAuthorApproval().applyValue({ args0 -> args0 })

    /**
     * Set to `true` to disable merge request committers from approving their own merge requests.
     */
    public val mergeRequestsDisableCommittersApproval: Output<Boolean>
        get() = javaResource.mergeRequestsDisableCommittersApproval().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of a project to change MR approval configuration.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Set to `true` to require authentication to approve merge requests.
     */
    public val requirePasswordToApprove: Output<Boolean>
        get() = javaResource.requirePasswordToApprove().applyValue({ args0 -> args0 })

    /**
     * Set to `true` to remove all approvals in a merge request when new commits are pushed to its source branch. Default is `true`.
     */
    public val resetApprovalsOnPush: Output<Boolean>
        get() = javaResource.resetApprovalsOnPush().applyValue({ args0 -> args0 })

    /**
     * Reset approvals from Code Owners if their files changed. Can be enabled only if reset*approvals*on_push is disabled.
     */
    public val selectiveCodeOwnerRemovals: Output<Boolean>
        get() = javaResource.selectiveCodeOwnerRemovals().applyValue({ args0 -> args0 })
}

public object ProjectLevelMrApprovalsMapper : ResourceMapper<ProjectLevelMrApprovals> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectLevelMrApprovals::class == javaResource::class

    override fun map(javaResource: Resource): ProjectLevelMrApprovals =
        ProjectLevelMrApprovals(javaResource as com.pulumi.gitlab.ProjectLevelMrApprovals)
}

/**
 * @see [ProjectLevelMrApprovals].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectLevelMrApprovals].
 */
public suspend fun projectLevelMrApprovals(
    name: String,
    block: suspend ProjectLevelMrApprovalsResourceBuilder.() -> Unit,
): ProjectLevelMrApprovals {
    val builder = ProjectLevelMrApprovalsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectLevelMrApprovals].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectLevelMrApprovals(name: String): ProjectLevelMrApprovals {
    val builder = ProjectLevelMrApprovalsResourceBuilder()
    builder.name(name)
    return builder.build()
}
