@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectLevelNotifications].
 */
@PulumiTagMarker
public class ProjectLevelNotificationsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectLevelNotificationsArgs = ProjectLevelNotificationsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectLevelNotificationsArgsBuilder.() -> Unit) {
        val builder = ProjectLevelNotificationsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectLevelNotifications {
        val builtJavaResource = com.pulumi.gitlab.ProjectLevelNotifications(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectLevelNotifications(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectLevelNotifications` resource allows to manage notifications for a project.
 * > While the API supports both groups and projects, this resource only supports projects currently.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)
 */
public class ProjectLevelNotifications internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectLevelNotifications,
) : KotlinCustomResource(javaResource, ProjectLevelNotificationsMapper) {
    /**
     * Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    public val closeIssue: Output<Boolean>
        get() = javaResource.closeIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    public val closeMergeRequest: Output<Boolean>
        get() = javaResource.closeMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    public val failedPipeline: Output<Boolean>
        get() = javaResource.failedPipeline().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    public val fixedPipeline: Output<Boolean>
        get() = javaResource.fixedPipeline().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    public val issueDue: Output<Boolean>
        get() = javaResource.issueDue().applyValue({ args0 -> args0 })

    /**
     * The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    public val level: Output<String>
        get() = javaResource.level().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    public val mergeMergeRequest: Output<Boolean>
        get() = javaResource.mergeMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    public val mergeWhenPipelineSucceeds: Output<Boolean>
        get() = javaResource.mergeWhenPipelineSucceeds().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    public val movedProject: Output<Boolean>
        get() = javaResource.movedProject().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    public val newIssue: Output<Boolean>
        get() = javaResource.newIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    public val newMergeRequest: Output<Boolean>
        get() = javaResource.newMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    public val newNote: Output<Boolean>
        get() = javaResource.newNote().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of a project where notifications will be configured.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    public val pushToMergeRequest: Output<Boolean>
        get() = javaResource.pushToMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    public val reassignIssue: Output<Boolean>
        get() = javaResource.reassignIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    public val reassignMergeRequest: Output<Boolean>
        get() = javaResource.reassignMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    public val reopenIssue: Output<Boolean>
        get() = javaResource.reopenIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    public val reopenMergeRequest: Output<Boolean>
        get() = javaResource.reopenMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    public val successPipeline: Output<Boolean>
        get() = javaResource.successPipeline().applyValue({ args0 -> args0 })
}

public object ProjectLevelNotificationsMapper : ResourceMapper<ProjectLevelNotifications> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectLevelNotifications::class == javaResource::class

    override fun map(javaResource: Resource): ProjectLevelNotifications =
        ProjectLevelNotifications(javaResource as com.pulumi.gitlab.ProjectLevelNotifications)
}

/**
 * @see [ProjectLevelNotifications].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectLevelNotifications].
 */
public suspend fun projectLevelNotifications(
    name: String,
    block: suspend ProjectLevelNotificationsResourceBuilder.() -> Unit,
): ProjectLevelNotifications {
    val builder = ProjectLevelNotificationsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectLevelNotifications].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectLevelNotifications(name: String): ProjectLevelNotifications {
    val builder = ProjectLevelNotificationsResourceBuilder()
    builder.name(name)
    return builder.build()
}
