@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectLevelNotificationsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectLevelNotifications` resource allows to manage notifications for a project.
 * > While the API supports both groups and projects, this resource only supports projects currently.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)
 * @property closeIssue Enable notifications for closed issues. Can only be used when `level` is `custom`.
 * @property closeMergeRequest Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
 * @property failedPipeline Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
 * @property fixedPipeline Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
 * @property issueDue Enable notifications for due issues. Can only be used when `level` is `custom`.
 * @property level The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
 * @property mergeMergeRequest Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
 * @property mergeWhenPipelineSucceeds Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
 * @property movedProject Enable notifications for moved projects. Can only be used when `level` is `custom`.
 * @property newIssue Enable notifications for new issues. Can only be used when `level` is `custom`.
 * @property newMergeRequest Enable notifications for new merge requests. Can only be used when `level` is `custom`.
 * @property newNote Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
 * @property project The ID or URL-encoded path of a project where notifications will be configured.
 * @property pushToMergeRequest Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
 * @property reassignIssue Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
 * @property reassignMergeRequest Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
 * @property reopenIssue Enable notifications for reopened issues. Can only be used when `level` is `custom`.
 * @property reopenMergeRequest Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
 * @property successPipeline Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
 */
public data class ProjectLevelNotificationsArgs(
    public val closeIssue: Output<Boolean>? = null,
    public val closeMergeRequest: Output<Boolean>? = null,
    public val failedPipeline: Output<Boolean>? = null,
    public val fixedPipeline: Output<Boolean>? = null,
    public val issueDue: Output<Boolean>? = null,
    public val level: Output<String>? = null,
    public val mergeMergeRequest: Output<Boolean>? = null,
    public val mergeWhenPipelineSucceeds: Output<Boolean>? = null,
    public val movedProject: Output<Boolean>? = null,
    public val newIssue: Output<Boolean>? = null,
    public val newMergeRequest: Output<Boolean>? = null,
    public val newNote: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushToMergeRequest: Output<Boolean>? = null,
    public val reassignIssue: Output<Boolean>? = null,
    public val reassignMergeRequest: Output<Boolean>? = null,
    public val reopenIssue: Output<Boolean>? = null,
    public val reopenMergeRequest: Output<Boolean>? = null,
    public val successPipeline: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectLevelNotificationsArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectLevelNotificationsArgs =
        com.pulumi.gitlab.ProjectLevelNotificationsArgs.builder()
            .closeIssue(closeIssue?.applyValue({ args0 -> args0 }))
            .closeMergeRequest(closeMergeRequest?.applyValue({ args0 -> args0 }))
            .failedPipeline(failedPipeline?.applyValue({ args0 -> args0 }))
            .fixedPipeline(fixedPipeline?.applyValue({ args0 -> args0 }))
            .issueDue(issueDue?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .mergeMergeRequest(mergeMergeRequest?.applyValue({ args0 -> args0 }))
            .mergeWhenPipelineSucceeds(mergeWhenPipelineSucceeds?.applyValue({ args0 -> args0 }))
            .movedProject(movedProject?.applyValue({ args0 -> args0 }))
            .newIssue(newIssue?.applyValue({ args0 -> args0 }))
            .newMergeRequest(newMergeRequest?.applyValue({ args0 -> args0 }))
            .newNote(newNote?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushToMergeRequest(pushToMergeRequest?.applyValue({ args0 -> args0 }))
            .reassignIssue(reassignIssue?.applyValue({ args0 -> args0 }))
            .reassignMergeRequest(reassignMergeRequest?.applyValue({ args0 -> args0 }))
            .reopenIssue(reopenIssue?.applyValue({ args0 -> args0 }))
            .reopenMergeRequest(reopenMergeRequest?.applyValue({ args0 -> args0 }))
            .successPipeline(successPipeline?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectLevelNotificationsArgs].
 */
@PulumiTagMarker
public class ProjectLevelNotificationsArgsBuilder internal constructor() {
    private var closeIssue: Output<Boolean>? = null

    private var closeMergeRequest: Output<Boolean>? = null

    private var failedPipeline: Output<Boolean>? = null

    private var fixedPipeline: Output<Boolean>? = null

    private var issueDue: Output<Boolean>? = null

    private var level: Output<String>? = null

    private var mergeMergeRequest: Output<Boolean>? = null

    private var mergeWhenPipelineSucceeds: Output<Boolean>? = null

    private var movedProject: Output<Boolean>? = null

    private var newIssue: Output<Boolean>? = null

    private var newMergeRequest: Output<Boolean>? = null

    private var newNote: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushToMergeRequest: Output<Boolean>? = null

    private var reassignIssue: Output<Boolean>? = null

    private var reassignMergeRequest: Output<Boolean>? = null

    private var reopenIssue: Output<Boolean>? = null

    private var reopenMergeRequest: Output<Boolean>? = null

    private var successPipeline: Output<Boolean>? = null

    /**
     * @param value Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    @JvmName("tkmubjtpojxfiuxa")
    public suspend fun closeIssue(`value`: Output<Boolean>) {
        this.closeIssue = value
    }

    /**
     * @param value Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("fojgwpdxsdcmkqsf")
    public suspend fun closeMergeRequest(`value`: Output<Boolean>) {
        this.closeMergeRequest = value
    }

    /**
     * @param value Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("ceewacafenmeapee")
    public suspend fun failedPipeline(`value`: Output<Boolean>) {
        this.failedPipeline = value
    }

    /**
     * @param value Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("sxvmquqwvrbxnbdx")
    public suspend fun fixedPipeline(`value`: Output<Boolean>) {
        this.fixedPipeline = value
    }

    /**
     * @param value Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    @JvmName("pcvdboomtjglphfh")
    public suspend fun issueDue(`value`: Output<Boolean>) {
        this.issueDue = value
    }

    /**
     * @param value The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    @JvmName("lvdppaohvetrydoc")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("otyaddsdauefbveu")
    public suspend fun mergeMergeRequest(`value`: Output<Boolean>) {
        this.mergeMergeRequest = value
    }

    /**
     * @param value Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    @JvmName("vksvoxhsbnqwkxnv")
    public suspend fun mergeWhenPipelineSucceeds(`value`: Output<Boolean>) {
        this.mergeWhenPipelineSucceeds = value
    }

    /**
     * @param value Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    @JvmName("bqmwmmiqnoovbpun")
    public suspend fun movedProject(`value`: Output<Boolean>) {
        this.movedProject = value
    }

    /**
     * @param value Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    @JvmName("nurscojghgxetnmd")
    public suspend fun newIssue(`value`: Output<Boolean>) {
        this.newIssue = value
    }

    /**
     * @param value Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("ajdievbesnyhiltg")
    public suspend fun newMergeRequest(`value`: Output<Boolean>) {
        this.newMergeRequest = value
    }

    /**
     * @param value Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("spubrukoasvacdbs")
    public suspend fun newNote(`value`: Output<Boolean>) {
        this.newNote = value
    }

    /**
     * @param value The ID or URL-encoded path of a project where notifications will be configured.
     */
    @JvmName("ujclabdwtrxcfeec")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    @JvmName("vucahwcrwqfpbhno")
    public suspend fun pushToMergeRequest(`value`: Output<Boolean>) {
        this.pushToMergeRequest = value
    }

    /**
     * @param value Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("drxrddspochinrmc")
    public suspend fun reassignIssue(`value`: Output<Boolean>) {
        this.reassignIssue = value
    }

    /**
     * @param value Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("jndwsvtescbrmdoe")
    public suspend fun reassignMergeRequest(`value`: Output<Boolean>) {
        this.reassignMergeRequest = value
    }

    /**
     * @param value Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    @JvmName("ukpoxdhtqbdftqvv")
    public suspend fun reopenIssue(`value`: Output<Boolean>) {
        this.reopenIssue = value
    }

    /**
     * @param value Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("nodohwxcytrabaek")
    public suspend fun reopenMergeRequest(`value`: Output<Boolean>) {
        this.reopenMergeRequest = value
    }

    /**
     * @param value Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("khneyedhixjbqfmt")
    public suspend fun successPipeline(`value`: Output<Boolean>) {
        this.successPipeline = value
    }

    /**
     * @param value Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    @JvmName("jugmqlgdlawnnpyu")
    public suspend fun closeIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closeIssue = mapped
    }

    /**
     * @param value Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("jwhrifpvlpemldos")
    public suspend fun closeMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closeMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("abveqajmtrtebhsq")
    public suspend fun failedPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failedPipeline = mapped
    }

    /**
     * @param value Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("qjmfoiwoyccmgpeq")
    public suspend fun fixedPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedPipeline = mapped
    }

    /**
     * @param value Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    @JvmName("iagkirbnkmlwjjvl")
    public suspend fun issueDue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueDue = mapped
    }

    /**
     * @param value The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    @JvmName("grlxsgdmtlykrhau")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("dlmroegehludclqf")
    public suspend fun mergeMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    @JvmName("hjeeyjsvgotirdon")
    public suspend fun mergeWhenPipelineSucceeds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeWhenPipelineSucceeds = mapped
    }

    /**
     * @param value Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    @JvmName("ypmppjhmfaeqlekl")
    public suspend fun movedProject(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.movedProject = mapped
    }

    /**
     * @param value Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    @JvmName("mwmamukevoxxjwns")
    public suspend fun newIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newIssue = mapped
    }

    /**
     * @param value Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("bnuywfkvcqvgnxqr")
    public suspend fun newMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("dexsiqsmdwflunrb")
    public suspend fun newNote(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNote = mapped
    }

    /**
     * @param value The ID or URL-encoded path of a project where notifications will be configured.
     */
    @JvmName("yfqwisrxltmohnhr")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    @JvmName("otcfybklwbrwwvas")
    public suspend fun pushToMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushToMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("rtrfdpjgmiohnffn")
    public suspend fun reassignIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reassignIssue = mapped
    }

    /**
     * @param value Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("xegpnnkcxrqjqdwk")
    public suspend fun reassignMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reassignMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    @JvmName("cuvcymdiuooodtkl")
    public suspend fun reopenIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reopenIssue = mapped
    }

    /**
     * @param value Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("cxaoysnbviifacxx")
    public suspend fun reopenMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reopenMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("natmgynkpbkojjan")
    public suspend fun successPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successPipeline = mapped
    }

    internal fun build(): ProjectLevelNotificationsArgs = ProjectLevelNotificationsArgs(
        closeIssue = closeIssue,
        closeMergeRequest = closeMergeRequest,
        failedPipeline = failedPipeline,
        fixedPipeline = fixedPipeline,
        issueDue = issueDue,
        level = level,
        mergeMergeRequest = mergeMergeRequest,
        mergeWhenPipelineSucceeds = mergeWhenPipelineSucceeds,
        movedProject = movedProject,
        newIssue = newIssue,
        newMergeRequest = newMergeRequest,
        newNote = newNote,
        project = project,
        pushToMergeRequest = pushToMergeRequest,
        reassignIssue = reassignIssue,
        reassignMergeRequest = reassignMergeRequest,
        reopenIssue = reopenIssue,
        reopenMergeRequest = reopenMergeRequest,
        successPipeline = successPipeline,
    )
}
