@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectMembership].
 */
@PulumiTagMarker
public class ProjectMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectMembershipArgs = ProjectMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectMembershipArgsBuilder.() -> Unit) {
        val builder = ProjectMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectMembership {
        val builtJavaResource = com.pulumi.gitlab.ProjectMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectMembership(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectMembership` resource allows to manage the lifecycle of a users project membership.
 * > If a project should grant membership to an entire group use the `gitlab.ProjectShareGroup` resource instead.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.ProjectMembership("test", {
 *     project: "12345",
 *     userId: 1337,
 *     accessLevel: "guest",
 * });
 * const example = new gitlab.ProjectMembership("example", {
 *     project: "67890",
 *     userId: 1234,
 *     accessLevel: "guest",
 *     expiresAt: "2022-12-31",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.ProjectMembership("test",
 *     project="12345",
 *     user_id=1337,
 *     access_level="guest")
 * example = gitlab.ProjectMembership("example",
 *     project="67890",
 *     user_id=1234,
 *     access_level="guest",
 *     expires_at="2022-12-31")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.ProjectMembership("test", new()
 *     {
 *         Project = "12345",
 *         UserId = 1337,
 *         AccessLevel = "guest",
 *     });
 *     var example = new GitLab.ProjectMembership("example", new()
 *     {
 *         Project = "67890",
 *         UserId = 1234,
 *         AccessLevel = "guest",
 *         ExpiresAt = "2022-12-31",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectMembership(ctx, "test", &gitlab.ProjectMembershipArgs{
 * 			Project:     pulumi.String("12345"),
 * 			UserId:      pulumi.Int(1337),
 * 			AccessLevel: pulumi.String("guest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectMembership(ctx, "example", &gitlab.ProjectMembershipArgs{
 * 			Project:     pulumi.String("67890"),
 * 			UserId:      pulumi.Int(1234),
 * 			AccessLevel: pulumi.String("guest"),
 * 			ExpiresAt:   pulumi.String("2022-12-31"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectMembership;
 * import com.pulumi.gitlab.ProjectMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ProjectMembership("test", ProjectMembershipArgs.builder()
 *             .project("12345")
 *             .userId(1337)
 *             .accessLevel("guest")
 *             .build());
 *         var example = new ProjectMembership("example", ProjectMembershipArgs.builder()
 *             .project("67890")
 *             .userId(1234)
 *             .accessLevel("guest")
 *             .expiresAt("2022-12-31")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:ProjectMembership
 *     properties:
 *       project: '12345'
 *       userId: 1337
 *       accessLevel: guest
 *   example:
 *     type: gitlab:ProjectMembership
 *     properties:
 *       project: '67890'
 *       userId: 1234
 *       accessLevel: guest
 *       expiresAt: 2022-12-31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project membership can be imported using an id made up of `project_id:user_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectMembership:ProjectMembership test "12345:1337"
 * ```
 */
public class ProjectMembership internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectMembership,
) : KotlinCustomResource(javaResource, ProjectMembershipMapper) {
    /**
     * The access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * Expiration date for the project membership. Format: `YYYY-MM-DD`
     */
    public val expiresAt: Output<String>?
        get() = javaResource.expiresAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID or URL-encoded path of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The id of the user.
     */
    public val userId: Output<Int>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object ProjectMembershipMapper : ResourceMapper<ProjectMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectMembership::class == javaResource::class

    override fun map(javaResource: Resource): ProjectMembership = ProjectMembership(
        javaResource as
            com.pulumi.gitlab.ProjectMembership,
    )
}

/**
 * @see [ProjectMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectMembership].
 */
public suspend fun projectMembership(
    name: String,
    block: suspend ProjectMembershipResourceBuilder.() -> Unit,
): ProjectMembership {
    val builder = ProjectMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectMembership(name: String): ProjectMembership {
    val builder = ProjectMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
