@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectMembershipArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectMembership` resource allows to manage the lifecycle of a users project membership.
 * > If a project should grant membership to an entire group use the `gitlab.ProjectShareGroup` resource instead.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.ProjectMembership("test", {
 *     project: "12345",
 *     userId: 1337,
 *     accessLevel: "guest",
 * });
 * const example = new gitlab.ProjectMembership("example", {
 *     project: "67890",
 *     userId: 1234,
 *     accessLevel: "guest",
 *     expiresAt: "2022-12-31",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.ProjectMembership("test",
 *     project="12345",
 *     user_id=1337,
 *     access_level="guest")
 * example = gitlab.ProjectMembership("example",
 *     project="67890",
 *     user_id=1234,
 *     access_level="guest",
 *     expires_at="2022-12-31")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.ProjectMembership("test", new()
 *     {
 *         Project = "12345",
 *         UserId = 1337,
 *         AccessLevel = "guest",
 *     });
 *     var example = new GitLab.ProjectMembership("example", new()
 *     {
 *         Project = "67890",
 *         UserId = 1234,
 *         AccessLevel = "guest",
 *         ExpiresAt = "2022-12-31",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectMembership(ctx, "test", &gitlab.ProjectMembershipArgs{
 * 			Project:     pulumi.String("12345"),
 * 			UserId:      pulumi.Int(1337),
 * 			AccessLevel: pulumi.String("guest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectMembership(ctx, "example", &gitlab.ProjectMembershipArgs{
 * 			Project:     pulumi.String("67890"),
 * 			UserId:      pulumi.Int(1234),
 * 			AccessLevel: pulumi.String("guest"),
 * 			ExpiresAt:   pulumi.String("2022-12-31"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectMembership;
 * import com.pulumi.gitlab.ProjectMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ProjectMembership("test", ProjectMembershipArgs.builder()
 *             .project("12345")
 *             .userId(1337)
 *             .accessLevel("guest")
 *             .build());
 *         var example = new ProjectMembership("example", ProjectMembershipArgs.builder()
 *             .project("67890")
 *             .userId(1234)
 *             .accessLevel("guest")
 *             .expiresAt("2022-12-31")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:ProjectMembership
 *     properties:
 *       project: '12345'
 *       userId: 1337
 *       accessLevel: guest
 *   example:
 *     type: gitlab:ProjectMembership
 *     properties:
 *       project: '67890'
 *       userId: 1234
 *       accessLevel: guest
 *       expiresAt: 2022-12-31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project membership can be imported using an id made up of `project_id:user_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectMembership:ProjectMembership test "12345:1337"
 * ```
 * @property accessLevel The access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
 * @property expiresAt Expiration date for the project membership. Format: `YYYY-MM-DD`
 * @property project The ID or URL-encoded path of the project.
 * @property userId The id of the user.
 */
public data class ProjectMembershipArgs(
    public val accessLevel: Output<String>? = null,
    public val expiresAt: Output<String>? = null,
    public val project: Output<String>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectMembershipArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectMembershipArgs =
        com.pulumi.gitlab.ProjectMembershipArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectMembershipArgs].
 */
@PulumiTagMarker
public class ProjectMembershipArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var expiresAt: Output<String>? = null

    private var project: Output<String>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value The access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("nrvsnkshgkhrhxmp")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value Expiration date for the project membership. Format: `YYYY-MM-DD`
     */
    @JvmName("jkxssckpdspbpwjd")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("xiovhqcgminwkxmy")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("ixhcfgciditfoacw")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value The access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("bsvfjxvnpjqxhjeg")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value Expiration date for the project membership. Format: `YYYY-MM-DD`
     */
    @JvmName("igvppfrcaokfjfoj")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("uobrvsntdecvndst")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("hwkiciwfoygapwik")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): ProjectMembershipArgs = ProjectMembershipArgs(
        accessLevel = accessLevel,
        expiresAt = expiresAt,
        project = project,
        userId = userId,
    )
}
