@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectMilestone].
 */
@PulumiTagMarker
public class ProjectMilestoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectMilestoneArgs = ProjectMilestoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectMilestoneArgsBuilder.() -> Unit) {
        val builder = ProjectMilestoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectMilestone {
        val builtJavaResource = com.pulumi.gitlab.ProjectMilestone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectMilestone(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectMilestone` resource allows to manage the lifecycle of a project milestone.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/milestones.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Create a project for the milestone to use
 * const example = new gitlab.Project("example", {
 *     name: "example",
 *     description: "An example project",
 *     namespaceId: exampleGitlabGroup.id,
 * });
 * const exampleProjectMilestone = new gitlab.ProjectMilestone("example", {
 *     project: example.id,
 *     title: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Create a project for the milestone to use
 * example = gitlab.Project("example",
 *     name="example",
 *     description="An example project",
 *     namespace_id=example_gitlab_group["id"])
 * example_project_milestone = gitlab.ProjectMilestone("example",
 *     project=example.id,
 *     title="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a project for the milestone to use
 *     var example = new GitLab.Project("example", new()
 *     {
 *         Name = "example",
 *         Description = "An example project",
 *         NamespaceId = exampleGitlabGroup.Id,
 *     });
 *     var exampleProjectMilestone = new GitLab.ProjectMilestone("example", new()
 *     {
 *         Project = example.Id,
 *         Title = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a project for the milestone to use
 * 		example, err := gitlab.NewProject(ctx, "example", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("An example project"),
 * 			NamespaceId: pulumi.Any(exampleGitlabGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectMilestone(ctx, "example", &gitlab.ProjectMilestoneArgs{
 * 			Project: example.ID(),
 * 			Title:   pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectMilestone;
 * import com.pulumi.gitlab.ProjectMilestoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a project for the milestone to use
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .description("An example project")
 *             .namespaceId(exampleGitlabGroup.id())
 *             .build());
 *         var exampleProjectMilestone = new ProjectMilestone("exampleProjectMilestone", ProjectMilestoneArgs.builder()
 *             .project(example.id())
 *             .title("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a project for the milestone to use
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example
 *       description: An example project
 *       namespaceId: ${exampleGitlabGroup.id}
 *   exampleProjectMilestone:
 *     type: gitlab:ProjectMilestone
 *     name: example
 *     properties:
 *       project: ${example.id}
 *       title: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab project milestone can be imported with a key composed of `<project>:<milestone_id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectMilestone:ProjectMilestone example "12345:11"
 * ```
 */
public class ProjectMilestone internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectMilestone,
) : KotlinCustomResource(javaResource, ProjectMilestoneMapper) {
    /**
     * The time of creation of the milestone. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The description of the milestone.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The due date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
     */
    public val dueDate: Output<String>?
        get() = javaResource.dueDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Bool, true if milestone expired.
     */
    public val expired: Output<Boolean>
        get() = javaResource.expired().applyValue({ args0 -> args0 })

    /**
     * The ID of the project's milestone.
     */
    public val iid: Output<Int>
        get() = javaResource.iid().applyValue({ args0 -> args0 })

    /**
     * The instance-wide ID of the project’s milestone.
     */
    public val milestoneId: Output<Int>
        get() = javaResource.milestoneId().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of the project owned by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The project ID of milestone.
     */
    public val projectId: Output<Int>
        get() = javaResource.projectId().applyValue({ args0 -> args0 })

    /**
     * The start date of the milestone. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
     */
    public val startDate: Output<String>?
        get() = javaResource.startDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The state of the milestone. Valid values are: `active`, `closed`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The title of a milestone.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The last update time of the milestone. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The web URL of the milestone.
     */
    public val webUrl: Output<String>
        get() = javaResource.webUrl().applyValue({ args0 -> args0 })
}

public object ProjectMilestoneMapper : ResourceMapper<ProjectMilestone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectMilestone::class == javaResource::class

    override fun map(javaResource: Resource): ProjectMilestone = ProjectMilestone(
        javaResource as
            com.pulumi.gitlab.ProjectMilestone,
    )
}

/**
 * @see [ProjectMilestone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectMilestone].
 */
public suspend fun projectMilestone(
    name: String,
    block: suspend ProjectMilestoneResourceBuilder.() -> Unit,
): ProjectMilestone {
    val builder = ProjectMilestoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectMilestone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectMilestone(name: String): ProjectMilestone {
    val builder = ProjectMilestoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
