@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectMirror].
 */
@PulumiTagMarker
public class ProjectMirrorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectMirrorArgs = ProjectMirrorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectMirrorArgsBuilder.() -> Unit) {
        val builder = ProjectMirrorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectMirror {
        val builtJavaResource = com.pulumi.gitlab.ProjectMirror(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectMirror(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectMirror` resource allows to manage the lifecycle of a project mirror.
 * This is for *pushing* changes to a remote repository. *Pull Mirroring* can be configured using a combination of the
 * import_url, mirror, and mirror_trigger_builds properties on the gitlab.Project resource.
 * > **Warning** By default, the provider sets the `keep_divergent_refs` argument to `True`.
 *    If you manually set `keep_divergent_refs` to `False`, GitLab mirroring removes branches in the target that aren't in the source.
 *    This action can result in unexpected branch deletions.
 * > **Destroy Behavior** GitLab 14.10 introduced an API endpoint to delete a project mirror.
 *    Therefore, for GitLab 14.10 and newer the project mirror will be destroyed when the resource is destroyed.
 *    For older versions, the mirror will be disabled and the resource will be destroyed.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/remote_mirrors.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.ProjectMirror("foo", {
 *     project: "1",
 *     url: "https://username:password@github.com/org/repository.git",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.ProjectMirror("foo",
 *     project="1",
 *     url="https://username:password@github.com/org/repository.git")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.ProjectMirror("foo", new()
 *     {
 *         Project = "1",
 *         Url = "https://username:password@github.com/org/repository.git",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectMirror(ctx, "foo", &gitlab.ProjectMirrorArgs{
 * 			Project: pulumi.String("1"),
 * 			Url:     pulumi.String("https://username:password@github.com/org/repository.git"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectMirror;
 * import com.pulumi.gitlab.ProjectMirrorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ProjectMirror("foo", ProjectMirrorArgs.builder()
 *             .project("1")
 *             .url("https://username:password@github.com/org/repository.git")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:ProjectMirror
 *     properties:
 *       project: '1'
 *       url: https://username:password@github.com/org/repository.git
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project mirror can be imported using an id made up of `project_id:mirror_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectMirror:ProjectMirror foo "12345:1337"
 * ```
 */
public class ProjectMirror internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectMirror,
) : KotlinCustomResource(javaResource, ProjectMirrorMapper) {
    /**
     * Determines if the mirror is enabled.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Determines if divergent refs are skipped.
     */
    public val keepDivergentRefs: Output<Boolean>?
        get() = javaResource.keepDivergentRefs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Mirror ID.
     */
    public val mirrorId: Output<Int>
        get() = javaResource.mirrorId().applyValue({ args0 -> args0 })

    /**
     * Determines if only protected branches are mirrored.
     */
    public val onlyProtectedBranches: Output<Boolean>?
        get() = javaResource.onlyProtectedBranches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The URL of the remote repository to be mirrored.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object ProjectMirrorMapper : ResourceMapper<ProjectMirror> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectMirror::class == javaResource::class

    override fun map(javaResource: Resource): ProjectMirror = ProjectMirror(
        javaResource as
            com.pulumi.gitlab.ProjectMirror,
    )
}

/**
 * @see [ProjectMirror].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectMirror].
 */
public suspend fun projectMirror(
    name: String,
    block: suspend ProjectMirrorResourceBuilder.() -> Unit,
): ProjectMirror {
    val builder = ProjectMirrorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectMirror].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectMirror(name: String): ProjectMirror {
    val builder = ProjectMirrorResourceBuilder()
    builder.name(name)
    return builder.build()
}
