@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ProjectProtectedEnvironmentApprovalRule
import com.pulumi.gitlab.kotlin.outputs.ProjectProtectedEnvironmentDeployAccessLevel
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.gitlab.kotlin.outputs.ProjectProtectedEnvironmentApprovalRule.Companion.toKotlin as projectProtectedEnvironmentApprovalRuleToKotlin
import com.pulumi.gitlab.kotlin.outputs.ProjectProtectedEnvironmentDeployAccessLevel.Companion.toKotlin as projectProtectedEnvironmentDeployAccessLevelToKotlin

/**
 * Builder for [ProjectProtectedEnvironment].
 */
@PulumiTagMarker
public class ProjectProtectedEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectProtectedEnvironmentArgs = ProjectProtectedEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectProtectedEnvironmentArgsBuilder.() -> Unit) {
        val builder = ProjectProtectedEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectProtectedEnvironment {
        val builtJavaResource = com.pulumi.gitlab.ProjectProtectedEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectProtectedEnvironment(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a project.
 * > In order to use a user or group in the `deploy_access_levels` configuration,
 *    you need to make sure that users have access to the project and groups must have this project shared.
 *    You may use the `gitlab.ProjectMembership` and `gitlab_project_shared_group` resources to achieve this.
 *    Unfortunately, the GitLab API does not complain about users and groups without access to the project and just ignores those.
 *    In case this happens you will get perpetual state diffs.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_environments.html)
 * ## Import
 * GitLab protected environments can be imported using an id made up of `projectId:environmentName`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectProtectedEnvironment:ProjectProtectedEnvironment bar 123:production
 * ```
 */
public class ProjectProtectedEnvironment internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectProtectedEnvironment,
) : KotlinCustomResource(javaResource, ProjectProtectedEnvironmentMapper) {
    /**
     * Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    public val approvalRules: Output<List<ProjectProtectedEnvironmentApprovalRule>>
        get() = javaResource.approvalRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> projectProtectedEnvironmentApprovalRuleToKotlin(args0) })
            })
        })

    /**
     * Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    public val deployAccessLevels: Output<List<ProjectProtectedEnvironmentDeployAccessLevel>>?
        get() = javaResource.deployAccessLevels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectProtectedEnvironmentDeployAccessLevelToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the environment.
     */
    public val environment: Output<String>
        get() = javaResource.environment().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project which the protected environment is created against.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ProjectProtectedEnvironmentMapper : ResourceMapper<ProjectProtectedEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectProtectedEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): ProjectProtectedEnvironment =
        ProjectProtectedEnvironment(javaResource as com.pulumi.gitlab.ProjectProtectedEnvironment)
}

/**
 * @see [ProjectProtectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectProtectedEnvironment].
 */
public suspend fun projectProtectedEnvironment(
    name: String,
    block: suspend ProjectProtectedEnvironmentResourceBuilder.() -> Unit,
): ProjectProtectedEnvironment {
    val builder = ProjectProtectedEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectProtectedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectProtectedEnvironment(name: String): ProjectProtectedEnvironment {
    val builder = ProjectProtectedEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
