@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectProtectedEnvironmentArgs.builder
import com.pulumi.gitlab.kotlin.inputs.ProjectProtectedEnvironmentApprovalRuleArgs
import com.pulumi.gitlab.kotlin.inputs.ProjectProtectedEnvironmentApprovalRuleArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.ProjectProtectedEnvironmentDeployAccessLevelArgs
import com.pulumi.gitlab.kotlin.inputs.ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectProtectedEnvironment` resource allows to manage the lifecycle of a protected environment in a project.
 * > In order to use a user or group in the `deploy_access_levels` configuration,
 *    you need to make sure that users have access to the project and groups must have this project shared.
 *    You may use the `gitlab.ProjectMembership` and `gitlab_project_shared_group` resources to achieve this.
 *    Unfortunately, the GitLab API does not complain about users and groups without access to the project and just ignores those.
 *    In case this happens you will get perpetual state diffs.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_environments.html)
 * ## Import
 * GitLab protected environments can be imported using an id made up of `projectId:environmentName`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectProtectedEnvironment:ProjectProtectedEnvironment bar 123:production
 * ```
 * @property approvalRules Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
 * @property deployAccessLevels Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
 * @property environment The name of the environment.
 * @property project The ID or full path of the project which the protected environment is created against.
 */
public data class ProjectProtectedEnvironmentArgs(
    public val approvalRules: Output<List<ProjectProtectedEnvironmentApprovalRuleArgs>>? = null,
    public val deployAccessLevels: Output<List<ProjectProtectedEnvironmentDeployAccessLevelArgs>>? =
        null,
    public val environment: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectProtectedEnvironmentArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectProtectedEnvironmentArgs =
        com.pulumi.gitlab.ProjectProtectedEnvironmentArgs.builder()
            .approvalRules(
                approvalRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deployAccessLevels(
                deployAccessLevels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environment(environment?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectProtectedEnvironmentArgs].
 */
@PulumiTagMarker
public class ProjectProtectedEnvironmentArgsBuilder internal constructor() {
    private var approvalRules: Output<List<ProjectProtectedEnvironmentApprovalRuleArgs>>? = null

    private var deployAccessLevels: Output<List<ProjectProtectedEnvironmentDeployAccessLevelArgs>>? =
        null

    private var environment: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("nebkjgxgaugnjlqw")
    public suspend fun approvalRules(`value`: Output<List<ProjectProtectedEnvironmentApprovalRuleArgs>>) {
        this.approvalRules = value
    }

    @JvmName("ujbyakhurjqnasux")
    public suspend fun approvalRules(vararg values: Output<ProjectProtectedEnvironmentApprovalRuleArgs>) {
        this.approvalRules = Output.all(values.asList())
    }

    /**
     * @param values Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("iuonpcxbqayulpxx")
    public suspend fun approvalRules(values: List<Output<ProjectProtectedEnvironmentApprovalRuleArgs>>) {
        this.approvalRules = Output.all(values)
    }

    /**
     * @param value Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("uoifpgfumvqnkmul")
    public suspend fun deployAccessLevels(`value`: Output<List<ProjectProtectedEnvironmentDeployAccessLevelArgs>>) {
        this.deployAccessLevels = value
    }

    @JvmName("aglilfmofsdpohyn")
    public suspend fun deployAccessLevels(vararg values: Output<ProjectProtectedEnvironmentDeployAccessLevelArgs>) {
        this.deployAccessLevels = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("jkubyytfnatsjkls")
    public suspend fun deployAccessLevels(values: List<Output<ProjectProtectedEnvironmentDeployAccessLevelArgs>>) {
        this.deployAccessLevels = Output.all(values)
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("tiujuvdlwgvjaede")
    public suspend fun environment(`value`: Output<String>) {
        this.environment = value
    }

    /**
     * @param value The ID or full path of the project which the protected environment is created against.
     */
    @JvmName("yotxscxputainpst")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("gcvwycxnsmndkcuu")
    public suspend fun approvalRules(`value`: List<ProjectProtectedEnvironmentApprovalRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("jkoxswhmgiqymwxg")
    public suspend fun approvalRules(argument: List<suspend ProjectProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("lvebnycmcivbhydu")
    public suspend fun approvalRules(vararg argument: suspend ProjectProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param argument Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("oqyjnpmnddfrjtjm")
    public suspend fun approvalRules(argument: suspend ProjectProtectedEnvironmentApprovalRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectProtectedEnvironmentApprovalRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.approvalRules = mapped
    }

    /**
     * @param values Array of approval rules to deploy, with each described by a hash. Elements in the `approval_rules` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("tvlplqjylhbmvxdg")
    public suspend fun approvalRules(vararg values: ProjectProtectedEnvironmentApprovalRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.approvalRules = mapped
    }

    /**
     * @param value Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("wgsivjjxnrrxijym")
    public suspend fun deployAccessLevels(`value`: List<ProjectProtectedEnvironmentDeployAccessLevelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("emhdbmqnskmdqcjt")
    public suspend fun deployAccessLevels(argument: List<suspend ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("gbqkblmfgndoupcx")
    public suspend fun deployAccessLevels(vararg argument: suspend ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param argument Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("mxhauyhutkyuuhmi")
    public suspend fun deployAccessLevels(argument: suspend ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectProtectedEnvironmentDeployAccessLevelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.deployAccessLevels = mapped
    }

    /**
     * @param values Array of access levels allowed to deploy, with each described by a hash.  Elements in the `deploy_access_levels` should be one of `user_id`, `group_id` or `access_level`.
     */
    @JvmName("mtnisylxlkcbjieq")
    public suspend fun deployAccessLevels(vararg values: ProjectProtectedEnvironmentDeployAccessLevelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deployAccessLevels = mapped
    }

    /**
     * @param value The name of the environment.
     */
    @JvmName("kntgbynebryomaaa")
    public suspend fun environment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The ID or full path of the project which the protected environment is created against.
     */
    @JvmName("deylohargxrbldie")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ProjectProtectedEnvironmentArgs = ProjectProtectedEnvironmentArgs(
        approvalRules = approvalRules,
        deployAccessLevels = deployAccessLevels,
        environment = environment,
        project = project,
    )
}
