@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectPushRules].
 */
@PulumiTagMarker
public class ProjectPushRulesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectPushRulesArgs = ProjectPushRulesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectPushRulesArgsBuilder.() -> Unit) {
        val builder = ProjectPushRulesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectPushRules {
        val builtJavaResource = com.pulumi.gitlab.ProjectPushRules(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectPushRules(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const sample = new gitlab.ProjectPushRules("sample", {
 *     project: "42",
 *     authorEmailRegex: "@gitlab.com$",
 *     branchNameRegex: "(feat|fix)\\/*",
 *     commitCommitterCheck: true,
 *     commitCommitterNameCheck: true,
 *     commitMessageNegativeRegex: "ssh\\:\\/\\/",
 *     commitMessageRegex: "(feat|fix):.*",
 *     denyDeleteTag: false,
 *     fileNameRegex: "(jar|exe)$",
 *     maxFileSize: 4,
 *     memberCheck: true,
 *     preventSecrets: true,
 *     rejectUnsignedCommits: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * sample = gitlab.ProjectPushRules("sample",
 *     project="42",
 *     author_email_regex="@gitlab.com$",
 *     branch_name_regex="(feat|fix)\\/*",
 *     commit_committer_check=True,
 *     commit_committer_name_check=True,
 *     commit_message_negative_regex="ssh\\:\\/\\/",
 *     commit_message_regex="(feat|fix):.*",
 *     deny_delete_tag=False,
 *     file_name_regex="(jar|exe)$",
 *     max_file_size=4,
 *     member_check=True,
 *     prevent_secrets=True,
 *     reject_unsigned_commits=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sample = new GitLab.ProjectPushRules("sample", new()
 *     {
 *         Project = "42",
 *         AuthorEmailRegex = "@gitlab.com$",
 *         BranchNameRegex = "(feat|fix)\\/*",
 *         CommitCommitterCheck = true,
 *         CommitCommitterNameCheck = true,
 *         CommitMessageNegativeRegex = "ssh\\:\\/\\/",
 *         CommitMessageRegex = "(feat|fix):.*",
 *         DenyDeleteTag = false,
 *         FileNameRegex = "(jar|exe)$",
 *         MaxFileSize = 4,
 *         MemberCheck = true,
 *         PreventSecrets = true,
 *         RejectUnsignedCommits = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectPushRules(ctx, "sample", &gitlab.ProjectPushRulesArgs{
 * 			Project:                    pulumi.String("42"),
 * 			AuthorEmailRegex:           pulumi.String("@gitlab.com$"),
 * 			BranchNameRegex:            pulumi.String("(feat|fix)\\/*"),
 * 			CommitCommitterCheck:       pulumi.Bool(true),
 * 			CommitCommitterNameCheck:   pulumi.Bool(true),
 * 			CommitMessageNegativeRegex: pulumi.String("ssh\\:\\/\\/"),
 * 			CommitMessageRegex:         pulumi.String("(feat|fix):.*"),
 * 			DenyDeleteTag:              pulumi.Bool(false),
 * 			FileNameRegex:              pulumi.String("(jar|exe)$"),
 * 			MaxFileSize:                pulumi.Int(4),
 * 			MemberCheck:                pulumi.Bool(true),
 * 			PreventSecrets:             pulumi.Bool(true),
 * 			RejectUnsignedCommits:      pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectPushRules;
 * import com.pulumi.gitlab.ProjectPushRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new ProjectPushRules("sample", ProjectPushRulesArgs.builder()
 *             .project(42)
 *             .authorEmailRegex("@gitlab.com$")
 *             .branchNameRegex("(feat|fix)\\/*")
 *             .commitCommitterCheck(true)
 *             .commitCommitterNameCheck(true)
 *             .commitMessageNegativeRegex("ssh\\:\\/\\/")
 *             .commitMessageRegex("(feat|fix):.*")
 *             .denyDeleteTag(false)
 *             .fileNameRegex("(jar|exe)$")
 *             .maxFileSize(4)
 *             .memberCheck(true)
 *             .preventSecrets(true)
 *             .rejectUnsignedCommits(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sample:
 *     type: gitlab:ProjectPushRules
 *     properties:
 *       project: 42
 *       authorEmailRegex: '@gitlab.com$'
 *       branchNameRegex: (feat|fix)\/*
 *       commitCommitterCheck: true
 *       commitCommitterNameCheck: true
 *       commitMessageNegativeRegex: ssh\:\/\/
 *       commitMessageRegex: (feat|fix):.*
 *       denyDeleteTag: false
 *       fileNameRegex: (jar|exe)$
 *       maxFileSize: 4
 *       memberCheck: true
 *       preventSecrets: true
 *       rejectUnsignedCommits: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab project push rules can be imported with a key composed of `<project_id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectPushRules:ProjectPushRules sample "42"
 * ```
 * */*/*/*/*/*/
 */
public class ProjectPushRules internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectPushRules,
) : KotlinCustomResource(javaResource, ProjectPushRulesMapper) {
    /**
     * All commit author emails must match this regex, e.g. `@my-company.com$`.
     */
    public val authorEmailRegex: Output<String>
        get() = javaResource.authorEmailRegex().applyValue({ args0 -> args0 })

    /**
     * All branch names must match this regex, e.g. `(feature|hotfix)\/*`.
     * */
     */
    public val branchNameRegex: Output<String>
        get() = javaResource.branchNameRegex().applyValue({ args0 -> args0 })

    /**
     * Users can only push commits to this repository that were committed with one of their own verified emails.
     */
    public val commitCommitterCheck: Output<Boolean>
        get() = javaResource.commitCommitterCheck().applyValue({ args0 -> args0 })

    /**
     * Users can only push commits to this repository if the commit author name is consistent with their GitLab account name.
     */
    public val commitCommitterNameCheck: Output<Boolean>
        get() = javaResource.commitCommitterNameCheck().applyValue({ args0 -> args0 })

    /**
     * No commit message is allowed to match this regex, e.g. `ssh\:\/\/`.
     */
    public val commitMessageNegativeRegex: Output<String>
        get() = javaResource.commitMessageNegativeRegex().applyValue({ args0 -> args0 })

    /**
     * All commit messages must match this regex, e.g. `Fixed \d+\..*`.
     */
    public val commitMessageRegex: Output<String>
        get() = javaResource.commitMessageRegex().applyValue({ args0 -> args0 })

    /**
     * Deny deleting a tag.
     */
    public val denyDeleteTag: Output<Boolean>
        get() = javaResource.denyDeleteTag().applyValue({ args0 -> args0 })

    /**
     * All committed filenames must not match this regex, e.g. `(jar|exe)$`.
     */
    public val fileNameRegex: Output<String>
        get() = javaResource.fileNameRegex().applyValue({ args0 -> args0 })

    /**
     * Maximum file size (MB).
     */
    public val maxFileSize: Output<Int>
        get() = javaResource.maxFileSize().applyValue({ args0 -> args0 })

    /**
     * Restrict commits by author (email) to existing GitLab users.
     */
    public val memberCheck: Output<Boolean>
        get() = javaResource.memberCheck().applyValue({ args0 -> args0 })

    /**
     * GitLab will reject any files that are likely to contain secrets.
     */
    public val preventSecrets: Output<Boolean>
        get() = javaResource.preventSecrets().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Reject commit when it’s not DCO certified.
     */
    public val rejectNonDcoCommits: Output<Boolean>
        get() = javaResource.rejectNonDcoCommits().applyValue({ args0 -> args0 })

    /**
     * Reject commit when it’s not signed.
     */
    public val rejectUnsignedCommits: Output<Boolean>
        get() = javaResource.rejectUnsignedCommits().applyValue({ args0 -> args0 })
}

public object ProjectPushRulesMapper : ResourceMapper<ProjectPushRules> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectPushRules::class == javaResource::class

    override fun map(javaResource: Resource): ProjectPushRules = ProjectPushRules(
        javaResource as
            com.pulumi.gitlab.ProjectPushRules,
    )
}

/**
 * @see [ProjectPushRules].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectPushRules].
 */
public suspend fun projectPushRules(
    name: String,
    block: suspend ProjectPushRulesResourceBuilder.() -> Unit,
): ProjectPushRules {
    val builder = ProjectPushRulesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectPushRules].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectPushRules(name: String): ProjectPushRules {
    val builder = ProjectPushRulesResourceBuilder()
    builder.name(name)
    return builder.build()
}
