@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectRunnerEnablement].
 */
@PulumiTagMarker
public class ProjectRunnerEnablementResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectRunnerEnablementArgs = ProjectRunnerEnablementArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectRunnerEnablementArgsBuilder.() -> Unit) {
        val builder = ProjectRunnerEnablementArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectRunnerEnablement {
        val builtJavaResource = com.pulumi.gitlab.ProjectRunnerEnablement(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectRunnerEnablement(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectRunnerEnablement` resource allows to enable a runner in a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/runners.html#enable-a-runner-in-project)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.ProjectRunnerEnablement("foo", {
 *     project: "5",
 *     runnerId: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.ProjectRunnerEnablement("foo",
 *     project="5",
 *     runner_id=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.ProjectRunnerEnablement("foo", new()
 *     {
 *         Project = "5",
 *         RunnerId = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectRunnerEnablement(ctx, "foo", &gitlab.ProjectRunnerEnablementArgs{
 * 			Project:  pulumi.String("5"),
 * 			RunnerId: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectRunnerEnablement;
 * import com.pulumi.gitlab.ProjectRunnerEnablementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ProjectRunnerEnablement("foo", ProjectRunnerEnablementArgs.builder()
 *             .project(5)
 *             .runnerId(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:ProjectRunnerEnablement
 *     properties:
 *       project: 5
 *       runnerId: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project runners can be imported using an id made up of `project:runner_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectRunnerEnablement:ProjectRunnerEnablement foo 5:7
 * ```
 */
public class ProjectRunnerEnablement internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectRunnerEnablement,
) : KotlinCustomResource(javaResource, ProjectRunnerEnablementMapper) {
    /**
     * The ID or URL-encoded path of the project owned by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The ID of a runner to enable for the project.
     */
    public val runnerId: Output<Int>
        get() = javaResource.runnerId().applyValue({ args0 -> args0 })
}

public object ProjectRunnerEnablementMapper : ResourceMapper<ProjectRunnerEnablement> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectRunnerEnablement::class == javaResource::class

    override fun map(javaResource: Resource): ProjectRunnerEnablement =
        ProjectRunnerEnablement(javaResource as com.pulumi.gitlab.ProjectRunnerEnablement)
}

/**
 * @see [ProjectRunnerEnablement].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectRunnerEnablement].
 */
public suspend fun projectRunnerEnablement(
    name: String,
    block: suspend ProjectRunnerEnablementResourceBuilder.() -> Unit,
): ProjectRunnerEnablement {
    val builder = ProjectRunnerEnablementResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectRunnerEnablement].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectRunnerEnablement(name: String): ProjectRunnerEnablement {
    val builder = ProjectRunnerEnablementResourceBuilder()
    builder.name(name)
    return builder.build()
}
