@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectRunnerEnablementArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectRunnerEnablement` resource allows to enable a runner in a project.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/runners.html#enable-a-runner-in-project)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.ProjectRunnerEnablement("foo", {
 *     project: "5",
 *     runnerId: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.ProjectRunnerEnablement("foo",
 *     project="5",
 *     runner_id=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.ProjectRunnerEnablement("foo", new()
 *     {
 *         Project = "5",
 *         RunnerId = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectRunnerEnablement(ctx, "foo", &gitlab.ProjectRunnerEnablementArgs{
 * 			Project:  pulumi.String("5"),
 * 			RunnerId: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectRunnerEnablement;
 * import com.pulumi.gitlab.ProjectRunnerEnablementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new ProjectRunnerEnablement("foo", ProjectRunnerEnablementArgs.builder()
 *             .project(5)
 *             .runnerId(7)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:ProjectRunnerEnablement
 *     properties:
 *       project: 5
 *       runnerId: 7
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project runners can be imported using an id made up of `project:runner_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectRunnerEnablement:ProjectRunnerEnablement foo 5:7
 * ```
 * @property project The ID or URL-encoded path of the project owned by the authenticated user.
 * @property runnerId The ID of a runner to enable for the project.
 */
public data class ProjectRunnerEnablementArgs(
    public val project: Output<String>? = null,
    public val runnerId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectRunnerEnablementArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectRunnerEnablementArgs =
        com.pulumi.gitlab.ProjectRunnerEnablementArgs.builder()
            .project(project?.applyValue({ args0 -> args0 }))
            .runnerId(runnerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectRunnerEnablementArgs].
 */
@PulumiTagMarker
public class ProjectRunnerEnablementArgsBuilder internal constructor() {
    private var project: Output<String>? = null

    private var runnerId: Output<Int>? = null

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("qmmdlibbtkppekbb")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The ID of a runner to enable for the project.
     */
    @JvmName("gcjcvwimbiqblpsg")
    public suspend fun runnerId(`value`: Output<Int>) {
        this.runnerId = value
    }

    /**
     * @param value The ID or URL-encoded path of the project owned by the authenticated user.
     */
    @JvmName("jvplvmfulebtwwbt")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The ID of a runner to enable for the project.
     */
    @JvmName("hskgvyiurgutysrj")
    public suspend fun runnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runnerId = mapped
    }

    internal fun build(): ProjectRunnerEnablementArgs = ProjectRunnerEnablementArgs(
        project = project,
        runnerId = runnerId,
    )
}
