@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectSecurityPolicyAttachmentArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectSecurityPolicyAttachment` resource allows to attach a security policy project to a project.
 * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/index.html#mutationsecuritypolicyprojectassign)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // This resource can be used to attach a security policy to a pre-existing project
 * const foo = new gitlab.ProjectSecurityPolicyAttachment("foo", {
 *     project: "1234",
 *     policyProject: "4567",
 * });
 * // Or you can use Terraform to create a new project, add a policy to that project,
 * // then attach that policy project to other projects.
 * const my_policy_project = new gitlab.Project("my-policy-project", {name: "security-policy-project"});
 * const policy_yml = new gitlab.RepositoryFile("policy-yml", {
 *     project: my_policy_project.id,
 *     filePath: ".gitlab/security-policies/my-policy.yml",
 *     branch: "master",
 *     encoding: "text",
 *     content: `---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * `,
 * });
 * const my_policy = new gitlab.ProjectSecurityPolicyAttachment("my-policy", {
 *     project: "1234",
 *     policyProject: my_policy_project.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # This resource can be used to attach a security policy to a pre-existing project
 * foo = gitlab.ProjectSecurityPolicyAttachment("foo",
 *     project="1234",
 *     policy_project="4567")
 * # Or you can use Terraform to create a new project, add a policy to that project,
 * # then attach that policy project to other projects.
 * my_policy_project = gitlab.Project("my-policy-project", name="security-policy-project")
 * policy_yml = gitlab.RepositoryFile("policy-yml",
 *     project=my_policy_project.id,
 *     file_path=".gitlab/security-policies/my-policy.yml",
 *     branch="master",
 *     encoding="text",
 *     content="""---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * """)
 * my_policy = gitlab.ProjectSecurityPolicyAttachment("my-policy",
 *     project="1234",
 *     policy_project=my_policy_project.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // This resource can be used to attach a security policy to a pre-existing project
 *     var foo = new GitLab.ProjectSecurityPolicyAttachment("foo", new()
 *     {
 *         Project = "1234",
 *         PolicyProject = "4567",
 *     });
 *     // Or you can use Terraform to create a new project, add a policy to that project,
 *     // then attach that policy project to other projects.
 *     var my_policy_project = new GitLab.Project("my-policy-project", new()
 *     {
 *         Name = "security-policy-project",
 *     });
 *     var policy_yml = new GitLab.RepositoryFile("policy-yml", new()
 *     {
 *         Project = my_policy_project.Id,
 *         FilePath = ".gitlab/security-policies/my-policy.yml",
 *         Branch = "master",
 *         Encoding = "text",
 *         Content = @"---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * ",
 *     });
 *     var my_policy = new GitLab.ProjectSecurityPolicyAttachment("my-policy", new()
 *     {
 *         Project = "1234",
 *         PolicyProject = my_policy_project.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// This resource can be used to attach a security policy to a pre-existing project
 * 		_, err := gitlab.NewProjectSecurityPolicyAttachment(ctx, "foo", &gitlab.ProjectSecurityPolicyAttachmentArgs{
 * 			Project:       pulumi.String("1234"),
 * 			PolicyProject: pulumi.String("4567"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Or you can use Terraform to create a new project, add a policy to that project,
 * 		// then attach that policy project to other projects.
 * 		_, err = gitlab.NewProject(ctx, "my-policy-project", &gitlab.ProjectArgs{
 * 			Name: pulumi.String("security-policy-project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewRepositoryFile(ctx, "policy-yml", &gitlab.RepositoryFileArgs{
 * 			Project:  my_policy_project.ID(),
 * 			FilePath: pulumi.String(".gitlab/security-policies/my-policy.yml"),
 * 			Branch:   pulumi.String("master"),
 * 			Encoding: pulumi.String("text"),
 * 			Content: pulumi.String(`---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectSecurityPolicyAttachment(ctx, "my-policy", &gitlab.ProjectSecurityPolicyAttachmentArgs{
 * 			Project:       pulumi.String("1234"),
 * 			PolicyProject: my_policy_project.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectSecurityPolicyAttachment;
 * import com.pulumi.gitlab.ProjectSecurityPolicyAttachmentArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.RepositoryFile;
 * import com.pulumi.gitlab.RepositoryFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // This resource can be used to attach a security policy to a pre-existing project
 *         var foo = new ProjectSecurityPolicyAttachment("foo", ProjectSecurityPolicyAttachmentArgs.builder()
 *             .project(1234)
 *             .policyProject(4567)
 *             .build());
 *         // Or you can use Terraform to create a new project, add a policy to that project,
 *         // then attach that policy project to other projects.
 *         var my_policy_project = new Project("my-policy-project", ProjectArgs.builder()
 *             .name("security-policy-project")
 *             .build());
 *         var policy_yml = new RepositoryFile("policy-yml", RepositoryFileArgs.builder()
 *             .project(my_policy_project.id())
 *             .filePath(".gitlab/security-policies/my-policy.yml")
 *             .branch("master")
 *             .encoding("text")
 *             .content("""
 * ---
 * approval_policy:
 * - name: test
 * description: test
 * enabled: true
 * rules:
 * - type: any_merge_request
 *     branch_type: protected
 *     commits: any
 * approval_settings:
 *     block_branch_modification: true
 *     prevent_pushing_and_force_pushing: true
 *     prevent_approval_by_author: true
 *     prevent_approval_by_commit_author: true
 *     remove_approvals_with_new_commit: true
 *     require_password_to_approve: false
 * fallback_behavior:
 *     fail: closed
 * actions:
 * - type: send_bot_message
 *     enabled: true
 *             """)
 *             .build());
 *         var my_policy = new ProjectSecurityPolicyAttachment("my-policy", ProjectSecurityPolicyAttachmentArgs.builder()
 *             .project(1234)
 *             .policyProject(my_policy_project.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # This resource can be used to attach a security policy to a pre-existing project
 *   foo:
 *     type: gitlab:ProjectSecurityPolicyAttachment
 *     properties:
 *       project: 1234
 *       policyProject: 4567
 *   # Or you can use Terraform to create a new project, add a policy to that project,
 *   # then attach that policy project to other projects.
 *   my-policy-project:
 *     type: gitlab:Project
 *     properties:
 *       name: security-policy-project
 *   policy-yml:
 *     type: gitlab:RepositoryFile
 *     properties:
 *       project: ${["my-policy-project"].id}
 *       filePath: .gitlab/security-policies/my-policy.yml
 *       branch: master
 *       encoding: text
 *       content: |
 *         ---
 *         approval_policy:
 *         - name: test
 *         description: test
 *         enabled: true
 *         rules:
 *         - type: any_merge_request
 *             branch_type: protected
 *             commits: any
 *         approval_settings:
 *             block_branch_modification: true
 *             prevent_pushing_and_force_pushing: true
 *             prevent_approval_by_author: true
 *             prevent_approval_by_commit_author: true
 *             remove_approvals_with_new_commit: true
 *             require_password_to_approve: false
 *         fallback_behavior:
 *             fail: closed
 *         actions:
 *         - type: send_bot_message
 *             enabled: true
 *   my-policy:
 *     type: gitlab:ProjectSecurityPolicyAttachment
 *     properties:
 *       project: 1234
 *       policyProject: ${["my-policy-project"].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project security policy attachments can be imported using an id made up of `project:policy_project_id` where the policy project ID is the project ID of the policy project, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectSecurityPolicyAttachment:ProjectSecurityPolicyAttachment foo 1:2
 * ```
 * @property policyProject The ID or Full Path of the security policy project.
 * @property project The ID or Full Path of the project which will have the security policy project assigned to it.
 */
public data class ProjectSecurityPolicyAttachmentArgs(
    public val policyProject: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectSecurityPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectSecurityPolicyAttachmentArgs =
        com.pulumi.gitlab.ProjectSecurityPolicyAttachmentArgs.builder()
            .policyProject(policyProject?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecurityPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class ProjectSecurityPolicyAttachmentArgsBuilder internal constructor() {
    private var policyProject: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value The ID or Full Path of the security policy project.
     */
    @JvmName("xyiwvmjugqjnsrug")
    public suspend fun policyProject(`value`: Output<String>) {
        this.policyProject = value
    }

    /**
     * @param value The ID or Full Path of the project which will have the security policy project assigned to it.
     */
    @JvmName("ugpqjlybcypquyir")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The ID or Full Path of the security policy project.
     */
    @JvmName("dyiqnqnqbflojdcx")
    public suspend fun policyProject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyProject = mapped
    }

    /**
     * @param value The ID or Full Path of the project which will have the security policy project assigned to it.
     */
    @JvmName("qctbedpywwiejcti")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ProjectSecurityPolicyAttachmentArgs = ProjectSecurityPolicyAttachmentArgs(
        policyProject = policyProject,
        project = project,
    )
}
