@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectShareGroup].
 */
@PulumiTagMarker
public class ProjectShareGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectShareGroupArgs = ProjectShareGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectShareGroupArgsBuilder.() -> Unit) {
        val builder = ProjectShareGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectShareGroup {
        val builtJavaResource = com.pulumi.gitlab.ProjectShareGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectShareGroup(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectShareGroup` resource allows to manage the lifecycle of project shared with a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#share-project-with-group)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.ProjectShareGroup("test", {
 *     project: "12345",
 *     groupId: 1337,
 *     groupAccess: "guest",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.ProjectShareGroup("test",
 *     project="12345",
 *     group_id=1337,
 *     group_access="guest")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.ProjectShareGroup("test", new()
 *     {
 *         Project = "12345",
 *         GroupId = 1337,
 *         GroupAccess = "guest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectShareGroup(ctx, "test", &gitlab.ProjectShareGroupArgs{
 * 			Project:     pulumi.String("12345"),
 * 			GroupId:     pulumi.Int(1337),
 * 			GroupAccess: pulumi.String("guest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectShareGroup;
 * import com.pulumi.gitlab.ProjectShareGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ProjectShareGroup("test", ProjectShareGroupArgs.builder()
 *             .project("12345")
 *             .groupId(1337)
 *             .groupAccess("guest")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:ProjectShareGroup
 *     properties:
 *       project: '12345'
 *       groupId: 1337
 *       groupAccess: guest
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project group shares can be imported using an id made up of `projectid:groupid`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectShareGroup:ProjectShareGroup test 12345:1337
 * ```
 */
public class ProjectShareGroup internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectShareGroup,
) : KotlinCustomResource(javaResource, ProjectShareGroupMapper) {
    /**
     * The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @Deprecated(
        message = """
  Use `group_access` instead of the `access_level` attribute.
  """,
    )
    public val accessLevel: Output<String>?
        get() = javaResource.accessLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    public val groupAccess: Output<String>?
        get() = javaResource.groupAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the group.
     */
    public val groupId: Output<Int>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ProjectShareGroupMapper : ResourceMapper<ProjectShareGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectShareGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProjectShareGroup = ProjectShareGroup(
        javaResource as
            com.pulumi.gitlab.ProjectShareGroup,
    )
}

/**
 * @see [ProjectShareGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectShareGroup].
 */
public suspend fun projectShareGroup(
    name: String,
    block: suspend ProjectShareGroupResourceBuilder.() -> Unit,
): ProjectShareGroup {
    val builder = ProjectShareGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectShareGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectShareGroup(name: String): ProjectShareGroup {
    val builder = ProjectShareGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
