@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectShareGroupArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectShareGroup` resource allows to manage the lifecycle of project shared with a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#share-project-with-group)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.ProjectShareGroup("test", {
 *     project: "12345",
 *     groupId: 1337,
 *     groupAccess: "guest",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.ProjectShareGroup("test",
 *     project="12345",
 *     group_id=1337,
 *     group_access="guest")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.ProjectShareGroup("test", new()
 *     {
 *         Project = "12345",
 *         GroupId = 1337,
 *         GroupAccess = "guest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectShareGroup(ctx, "test", &gitlab.ProjectShareGroupArgs{
 * 			Project:     pulumi.String("12345"),
 * 			GroupId:     pulumi.Int(1337),
 * 			GroupAccess: pulumi.String("guest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectShareGroup;
 * import com.pulumi.gitlab.ProjectShareGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ProjectShareGroup("test", ProjectShareGroupArgs.builder()
 *             .project("12345")
 *             .groupId(1337)
 *             .groupAccess("guest")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:ProjectShareGroup
 *     properties:
 *       project: '12345'
 *       groupId: 1337
 *       groupAccess: guest
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project group shares can be imported using an id made up of `projectid:groupid`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectShareGroup:ProjectShareGroup test 12345:1337
 * ```
 * @property accessLevel The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
 * @property groupAccess The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
 * @property groupId The id of the group.
 * @property project The ID or URL-encoded path of the project.
 */
public data class ProjectShareGroupArgs(
    @Deprecated(
        message = """
  Use `group_access` instead of the `access_level` attribute.
  """,
    )
    public val accessLevel: Output<String>? = null,
    public val groupAccess: Output<String>? = null,
    public val groupId: Output<Int>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectShareGroupArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectShareGroupArgs =
        com.pulumi.gitlab.ProjectShareGroupArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .groupAccess(groupAccess?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectShareGroupArgs].
 */
@PulumiTagMarker
public class ProjectShareGroupArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var groupAccess: Output<String>? = null

    private var groupId: Output<Int>? = null

    private var project: Output<String>? = null

    /**
     * @param value The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @Deprecated(
        message = """
  Use `group_access` instead of the `access_level` attribute.
  """,
    )
    @JvmName("tutqxdmabknqifom")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("ismbvvjyouxaieas")
    public suspend fun groupAccess(`value`: Output<String>) {
        this.groupAccess = value
    }

    /**
     * @param value The id of the group.
     */
    @JvmName("cylshpmksmjydjry")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("tcuvdkwglmcejqbe")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @Deprecated(
        message = """
  Use `group_access` instead of the `access_level` attribute.
  """,
    )
    @JvmName("qqhqsjrkeanafxtf")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value The access level to grant the group for the project. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`
     */
    @JvmName("cnenrjitntppbhak")
    public suspend fun groupAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupAccess = mapped
    }

    /**
     * @param value The id of the group.
     */
    @JvmName("aepyxgxteqmavmyq")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ID or URL-encoded path of the project.
     */
    @JvmName("pmhyhiandfhyujpu")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ProjectShareGroupArgs = ProjectShareGroupArgs(
        accessLevel = accessLevel,
        groupAccess = groupAccess,
        groupId = groupId,
        project = project,
    )
}
