@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ProjectTagCommit
import com.pulumi.gitlab.kotlin.outputs.ProjectTagRelease
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.gitlab.kotlin.outputs.ProjectTagCommit.Companion.toKotlin as projectTagCommitToKotlin
import com.pulumi.gitlab.kotlin.outputs.ProjectTagRelease.Companion.toKotlin as projectTagReleaseToKotlin

/**
 * Builder for [ProjectTag].
 */
@PulumiTagMarker
public class ProjectTagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectTagArgs = ProjectTagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectTagArgsBuilder.() -> Unit) {
        val builder = ProjectTagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectTag {
        val builtJavaResource = com.pulumi.gitlab.ProjectTag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectTag(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectTag` resource allows to manage the lifecycle of a tag in a project.
 * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/tags.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Create a project for the tag to use
 * const example = new gitlab.Project("example", {
 *     name: "example",
 *     description: "An example project",
 *     namespaceId: exampleGitlabGroup.id,
 * });
 * const exampleProjectTag = new gitlab.ProjectTag("example", {
 *     name: "example",
 *     ref: "main",
 *     project: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Create a project for the tag to use
 * example = gitlab.Project("example",
 *     name="example",
 *     description="An example project",
 *     namespace_id=example_gitlab_group["id"])
 * example_project_tag = gitlab.ProjectTag("example",
 *     name="example",
 *     ref="main",
 *     project=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a project for the tag to use
 *     var example = new GitLab.Project("example", new()
 *     {
 *         Name = "example",
 *         Description = "An example project",
 *         NamespaceId = exampleGitlabGroup.Id,
 *     });
 *     var exampleProjectTag = new GitLab.ProjectTag("example", new()
 *     {
 *         Name = "example",
 *         Ref = "main",
 *         Project = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a project for the tag to use
 * 		example, err := gitlab.NewProject(ctx, "example", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("An example project"),
 * 			NamespaceId: pulumi.Any(exampleGitlabGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewProjectTag(ctx, "example", &gitlab.ProjectTagArgs{
 * 			Name:    pulumi.String("example"),
 * 			Ref:     pulumi.String("main"),
 * 			Project: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ProjectTag;
 * import com.pulumi.gitlab.ProjectTagArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a project for the tag to use
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .description("An example project")
 *             .namespaceId(exampleGitlabGroup.id())
 *             .build());
 *         var exampleProjectTag = new ProjectTag("exampleProjectTag", ProjectTagArgs.builder()
 *             .name("example")
 *             .ref("main")
 *             .project(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a project for the tag to use
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example
 *       description: An example project
 *       namespaceId: ${exampleGitlabGroup.id}
 *   exampleProjectTag:
 *     type: gitlab:ProjectTag
 *     name: example
 *     properties:
 *       name: example
 *       ref: main
 *       project: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab project tags can be imported with a key composed of `<project_id>:<tag_name>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectTag:ProjectTag example "12345:develop"
 * ```
 * NOTE: the `ref` attribute won't be available for imported `gitlab_project_tag` resources.
 */
public class ProjectTag internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectTag,
) : KotlinCustomResource(javaResource, ProjectTagMapper) {
    /**
     * The commit associated with the tag.
     */
    public val commits: Output<List<ProjectTagCommit>>
        get() = javaResource.commits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectTagCommitToKotlin(args0)
                })
            })
        })

    /**
     * The message of the annotated tag.
     */
    public val message: Output<String>?
        get() = javaResource.message().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of a tag.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or URL-encoded path of the project owned by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Bool, true if tag has tag protection.
     */
    public val `protected`: Output<Boolean>
        get() = javaResource.protected_().applyValue({ args0 -> args0 })

    /**
     * Create tag using commit SHA, another tag name, or branch name. This attribute is not available for imported resources.
     */
    public val ref: Output<String>
        get() = javaResource.ref().applyValue({ args0 -> args0 })

    /**
     * The release associated with the tag.
     */
    public val releases: Output<List<ProjectTagRelease>>
        get() = javaResource.releases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectTagReleaseToKotlin(args0)
                })
            })
        })

    /**
     * The unique id assigned to the commit by Gitlab.
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })
}

public object ProjectTagMapper : ResourceMapper<ProjectTag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectTag::class == javaResource::class

    override fun map(javaResource: Resource): ProjectTag = ProjectTag(
        javaResource as
            com.pulumi.gitlab.ProjectTag,
    )
}

/**
 * @see [ProjectTag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectTag].
 */
public suspend fun projectTag(name: String, block: suspend ProjectTagResourceBuilder.() -> Unit): ProjectTag {
    val builder = ProjectTagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectTag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectTag(name: String): ProjectTag {
    val builder = ProjectTagResourceBuilder()
    builder.name(name)
    return builder.build()
}
