@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProjectVariable].
 */
@PulumiTagMarker
public class ProjectVariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectVariableArgs = ProjectVariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectVariableArgsBuilder.() -> Unit) {
        val builder = ProjectVariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectVariable {
        val builtJavaResource = com.pulumi.gitlab.ProjectVariable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectVariable(builtJavaResource)
    }
}

/**
 * The `gitlab.ProjectVariable` resource allows to manage the lifecycle of a CI/CD variable for a project.
 * > **Important:** If your GitLab version is older than 13.4, you may see nondeterministic behavior when updating or deleting gitlab.ProjectVariable resources with non-unique keys, for example if there is another variable with the same key and different environment scope. See [this GitLab issue](https://gitlab.com/gitlab-org/gitlab/-/issues/9912).
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_level_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.ProjectVariable("example", {
 *     project: "12345",
 *     key: "project_variable_key",
 *     value: "project_variable_value",
 *     "protected": false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.ProjectVariable("example",
 *     project="12345",
 *     key="project_variable_key",
 *     value="project_variable_value",
 *     protected=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ProjectVariable("example", new()
 *     {
 *         Project = "12345",
 *         Key = "project_variable_key",
 *         Value = "project_variable_value",
 *         Protected = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectVariable(ctx, "example", &gitlab.ProjectVariableArgs{
 * 			Project:   pulumi.String("12345"),
 * 			Key:       pulumi.String("project_variable_key"),
 * 			Value:     pulumi.String("project_variable_value"),
 * 			Protected: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectVariable;
 * import com.pulumi.gitlab.ProjectVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProjectVariable("example", ProjectVariableArgs.builder()
 *             .project("12345")
 *             .key("project_variable_key")
 *             .value("project_variable_value")
 *             .protected_(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ProjectVariable
 *     properties:
 *       project: '12345'
 *       key: project_variable_key
 *       value: project_variable_value
 *       protected: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project variables can be imported using an id made up of `project:key:environment_scope`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectVariable:ProjectVariable example '12345:project_variable_key:*'
 * ```
 */
public class ProjectVariable internal constructor(
    override val javaResource: com.pulumi.gitlab.ProjectVariable,
) : KotlinCustomResource(javaResource, ProjectVariableMapper) {
    /**
     * The description of the variable.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    public val environmentScope: Output<String>?
        get() = javaResource.environmentScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the variable.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    public val masked: Output<Boolean>?
        get() = javaResource.masked().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name or id of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    public val `protected`: Output<Boolean>?
        get() = javaResource.protected_().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    public val raw: Output<Boolean>?
        get() = javaResource.raw().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The value of the variable.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    public val variableType: Output<String>?
        get() = javaResource.variableType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ProjectVariableMapper : ResourceMapper<ProjectVariable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ProjectVariable::class == javaResource::class

    override fun map(javaResource: Resource): ProjectVariable = ProjectVariable(
        javaResource as
            com.pulumi.gitlab.ProjectVariable,
    )
}

/**
 * @see [ProjectVariable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectVariable].
 */
public suspend fun projectVariable(
    name: String,
    block: suspend ProjectVariableResourceBuilder.() -> Unit,
): ProjectVariable {
    val builder = ProjectVariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectVariable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectVariable(name: String): ProjectVariable {
    val builder = ProjectVariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
