@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ProjectVariableArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ProjectVariable` resource allows to manage the lifecycle of a CI/CD variable for a project.
 * > **Important:** If your GitLab version is older than 13.4, you may see nondeterministic behavior when updating or deleting gitlab.ProjectVariable resources with non-unique keys, for example if there is another variable with the same key and different environment scope. See [this GitLab issue](https://gitlab.com/gitlab-org/gitlab/-/issues/9912).
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_level_variables.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.ProjectVariable("example", {
 *     project: "12345",
 *     key: "project_variable_key",
 *     value: "project_variable_value",
 *     "protected": false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.ProjectVariable("example",
 *     project="12345",
 *     key="project_variable_key",
 *     value="project_variable_value",
 *     protected=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ProjectVariable("example", new()
 *     {
 *         Project = "12345",
 *         Key = "project_variable_key",
 *         Value = "project_variable_value",
 *         Protected = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewProjectVariable(ctx, "example", &gitlab.ProjectVariableArgs{
 * 			Project:   pulumi.String("12345"),
 * 			Key:       pulumi.String("project_variable_key"),
 * 			Value:     pulumi.String("project_variable_value"),
 * 			Protected: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ProjectVariable;
 * import com.pulumi.gitlab.ProjectVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProjectVariable("example", ProjectVariableArgs.builder()
 *             .project("12345")
 *             .key("project_variable_key")
 *             .value("project_variable_value")
 *             .protected_(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ProjectVariable
 *     properties:
 *       project: '12345'
 *       key: project_variable_key
 *       value: project_variable_value
 *       protected: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab project variables can be imported using an id made up of `project:key:environment_scope`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/projectVariable:ProjectVariable example '12345:project_variable_key:*'
 * ```
 * @property description The description of the variable.
 * @property environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
 * @property key The name of the variable.
 * @property masked If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
 * @property project The name or id of the project.
 * @property protected If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
 * @property raw Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
 * @property value The value of the variable.
 * @property variableType The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
 */
public data class ProjectVariableArgs(
    public val description: Output<String>? = null,
    public val environmentScope: Output<String>? = null,
    public val key: Output<String>? = null,
    public val masked: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val `protected`: Output<Boolean>? = null,
    public val raw: Output<Boolean>? = null,
    public val `value`: Output<String>? = null,
    public val variableType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ProjectVariableArgs> {
    override fun toJava(): com.pulumi.gitlab.ProjectVariableArgs =
        com.pulumi.gitlab.ProjectVariableArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentScope(environmentScope?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .masked(masked?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .protected_(`protected`?.applyValue({ args0 -> args0 }))
            .raw(raw?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .variableType(variableType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectVariableArgs].
 */
@PulumiTagMarker
public class ProjectVariableArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var environmentScope: Output<String>? = null

    private var key: Output<String>? = null

    private var masked: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var `protected`: Output<Boolean>? = null

    private var raw: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    private var variableType: Output<String>? = null

    /**
     * @param value The description of the variable.
     */
    @JvmName("easxjepnyeqdhuqg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("jaclwkgoxfyfnqnn")
    public suspend fun environmentScope(`value`: Output<String>) {
        this.environmentScope = value
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("chblexigxhwasfsl")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("cmegqwlmlyidprmj")
    public suspend fun masked(`value`: Output<Boolean>) {
        this.masked = value
    }

    /**
     * @param value The name or id of the project.
     */
    @JvmName("jicsmowrhcbtusvd")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("fvenujmfvjincrud")
    public suspend fun `protected`(`value`: Output<Boolean>) {
        this.`protected` = value
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("qafxdtccntgnshtv")
    public suspend fun raw(`value`: Output<Boolean>) {
        this.raw = value
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("usftnvybaiijjqvs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("ylknrcvnvmpfrglf")
    public suspend fun variableType(`value`: Output<String>) {
        this.variableType = value
    }

    /**
     * @param value The description of the variable.
     */
    @JvmName("bpusptaalggypivc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     */
    @JvmName("fmfalopmcpvblgyc")
    public suspend fun environmentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentScope = mapped
    }

    /**
     * @param value The name of the variable.
     */
    @JvmName("vttcmngucbdxxclr")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value If set to `true`, the value of the variable will be hidden in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#masked-variables). Defaults to `false`.
     */
    @JvmName("txevwetxofpaqchu")
    public suspend fun masked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masked = mapped
    }

    /**
     * @param value The name or id of the project.
     */
    @JvmName("wbrejkxdgrbtqhmy")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value If set to `true`, the variable will be passed only to pipelines running on protected branches and tags. Defaults to `false`.
     */
    @JvmName("kcqvnjbdutynprnt")
    public suspend fun `protected`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`protected` = mapped
    }

    /**
     * @param value Whether the variable is treated as a raw string. Default: false. When true, variables in the value are not expanded.
     */
    @JvmName("njsnkwvihpdcecmb")
    public suspend fun raw(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raw = mapped
    }

    /**
     * @param value The value of the variable.
     */
    @JvmName("hafkdjbunqrcqovp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The type of a variable. Valid values are: `env_var`, `file`. Default is `env_var`.
     */
    @JvmName("rlifdxjcwihdbcgk")
    public suspend fun variableType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableType = mapped
    }

    internal fun build(): ProjectVariableArgs = ProjectVariableArgs(
        description = description,
        environmentScope = environmentScope,
        key = key,
        masked = masked,
        project = project,
        `protected` = `protected`,
        raw = raw,
        `value` = `value`,
        variableType = variableType,
    )
}
