@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReleaseLink].
 */
@PulumiTagMarker
public class ReleaseLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReleaseLinkArgs = ReleaseLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReleaseLinkArgsBuilder.() -> Unit) {
        val builder = ReleaseLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReleaseLink {
        val builtJavaResource = com.pulumi.gitlab.ReleaseLink(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReleaseLink(builtJavaResource)
    }
}

/**
 * The `gitlab.ReleaseLink` resource allows to manage the lifecycle of a release link.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/releases/links.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Create a project
 * const example = new gitlab.Project("example", {
 *     name: "example",
 *     description: "An example project",
 * });
 * // Can create release link only to a tag associated with a release
 * const exampleReleaseLink = new gitlab.ReleaseLink("example", {
 *     project: example.id,
 *     tagName: "tag_name_associated_with_release",
 *     name: "test",
 *     url: "https://test/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Create a project
 * example = gitlab.Project("example",
 *     name="example",
 *     description="An example project")
 * # Can create release link only to a tag associated with a release
 * example_release_link = gitlab.ReleaseLink("example",
 *     project=example.id,
 *     tag_name="tag_name_associated_with_release",
 *     name="test",
 *     url="https://test/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a project
 *     var example = new GitLab.Project("example", new()
 *     {
 *         Name = "example",
 *         Description = "An example project",
 *     });
 *     // Can create release link only to a tag associated with a release
 *     var exampleReleaseLink = new GitLab.ReleaseLink("example", new()
 *     {
 *         Project = example.Id,
 *         TagName = "tag_name_associated_with_release",
 *         Name = "test",
 *         Url = "https://test/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a project
 * 		example, err := gitlab.NewProject(ctx, "example", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("An example project"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Can create release link only to a tag associated with a release
 * 		_, err = gitlab.NewReleaseLink(ctx, "example", &gitlab.ReleaseLinkArgs{
 * 			Project: example.ID(),
 * 			TagName: pulumi.String("tag_name_associated_with_release"),
 * 			Name:    pulumi.String("test"),
 * 			Url:     pulumi.String("https://test/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ReleaseLink;
 * import com.pulumi.gitlab.ReleaseLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a project
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .description("An example project")
 *             .build());
 *         // Can create release link only to a tag associated with a release
 *         var exampleReleaseLink = new ReleaseLink("exampleReleaseLink", ReleaseLinkArgs.builder()
 *             .project(example.id())
 *             .tagName("tag_name_associated_with_release")
 *             .name("test")
 *             .url("https://test/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a project
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example
 *       description: An example project
 *   # Can create release link only to a tag associated with a release
 *   exampleReleaseLink:
 *     type: gitlab:ReleaseLink
 *     name: example
 *     properties:
 *       project: ${example.id}
 *       tagName: tag_name_associated_with_release
 *       name: test
 *       url: https://test/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab release link can be imported with a key composed of `<project>:<tag_name>:<link_id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/releaseLink:ReleaseLink example "12345:test:2"
 * ```
 */
public class ReleaseLink internal constructor(
    override val javaResource: com.pulumi.gitlab.ReleaseLink,
) : KotlinCustomResource(javaResource, ReleaseLinkMapper) {
    /**
     * Full path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
     */
    public val directAssetUrl: Output<String>
        get() = javaResource.directAssetUrl().applyValue({ args0 -> args0 })

    /**
     * External or internal link.
     */
    public val `external`: Output<Boolean>
        get() = javaResource.`external`().applyValue({ args0 -> args0 })

    /**
     * Relative path for a [Direct Asset link](https://docs.gitlab.com/ee/user/project/releases/index.html#permanent-links-to-release-assets).
     */
    public val filepath: Output<String>?
        get() = javaResource.filepath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the link.
     */
    public val linkId: Output<Int>
        get() = javaResource.linkId().applyValue({ args0 -> args0 })

    /**
     * The type of the link. Valid values are `other`, `runbook`, `image`, `package`. Defaults to other.
     */
    public val linkType: Output<String>?
        get() = javaResource.linkType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the link. Link names must be unique within the release.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The tag associated with the Release.
     */
    public val tagName: Output<String>
        get() = javaResource.tagName().applyValue({ args0 -> args0 })

    /**
     * The URL of the link. Link URLs must be unique within the release.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object ReleaseLinkMapper : ResourceMapper<ReleaseLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ReleaseLink::class == javaResource::class

    override fun map(javaResource: Resource): ReleaseLink = ReleaseLink(
        javaResource as
            com.pulumi.gitlab.ReleaseLink,
    )
}

/**
 * @see [ReleaseLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReleaseLink].
 */
public suspend fun releaseLink(name: String, block: suspend ReleaseLinkResourceBuilder.() -> Unit): ReleaseLink {
    val builder = ReleaseLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReleaseLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun releaseLink(name: String): ReleaseLink {
    val builder = ReleaseLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
