@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.RunnerArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.Runner` resource allows to manage the lifecycle of a runner.
 * A runner can either be registered at an instance level or group level.
 * The runner will be registered at a group level if the token used is from a group, or at an instance level if the token used is for the instance.
 * ~ > Using this resource will register a runner using the deprecated `registration_token` flow. To use the new `authentication_token` flow instead,
 * use the `gitlab.UserRunner` resource!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/runners.html#register-a-new-runner)
 * ## Import
 * A GitLab Runner can be imported using the runner's ID, eg
 * ```sh
 * $ pulumi import gitlab:index/runner:Runner this 1
 * ```
 * @property accessLevel The access_level of the runner. Valid values are: `not_protected`, `ref_protected`.
 * @property description The runner's description.
 * @property locked Whether the runner should be locked for current project.
 * @property maximumTimeout Maximum timeout set when this runner handles the job.
 * @property paused Whether the runner should ignore new jobs.
 * @property registrationToken The registration token used to register the runner.
 * @property runUntagged Whether the runner should handle untagged jobs.
 * @property tagLists List of runner’s tags.
 */
public data class RunnerArgs(
    public val accessLevel: Output<String>? = null,
    public val description: Output<String>? = null,
    public val locked: Output<Boolean>? = null,
    public val maximumTimeout: Output<Int>? = null,
    public val paused: Output<Boolean>? = null,
    public val registrationToken: Output<String>? = null,
    public val runUntagged: Output<Boolean>? = null,
    public val tagLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.RunnerArgs> {
    override fun toJava(): com.pulumi.gitlab.RunnerArgs = com.pulumi.gitlab.RunnerArgs.builder()
        .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .locked(locked?.applyValue({ args0 -> args0 }))
        .maximumTimeout(maximumTimeout?.applyValue({ args0 -> args0 }))
        .paused(paused?.applyValue({ args0 -> args0 }))
        .registrationToken(registrationToken?.applyValue({ args0 -> args0 }))
        .runUntagged(runUntagged?.applyValue({ args0 -> args0 }))
        .tagLists(tagLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RunnerArgs].
 */
@PulumiTagMarker
public class RunnerArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var description: Output<String>? = null

    private var locked: Output<Boolean>? = null

    private var maximumTimeout: Output<Int>? = null

    private var paused: Output<Boolean>? = null

    private var registrationToken: Output<String>? = null

    private var runUntagged: Output<Boolean>? = null

    private var tagLists: Output<List<String>>? = null

    /**
     * @param value The access_level of the runner. Valid values are: `not_protected`, `ref_protected`.
     */
    @JvmName("lqcibocfpxowqoum")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value The runner's description.
     */
    @JvmName("qpowicfdystnennc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the runner should be locked for current project.
     */
    @JvmName("shufghmjypyiiiks")
    public suspend fun locked(`value`: Output<Boolean>) {
        this.locked = value
    }

    /**
     * @param value Maximum timeout set when this runner handles the job.
     */
    @JvmName("saqvosncviaalwyd")
    public suspend fun maximumTimeout(`value`: Output<Int>) {
        this.maximumTimeout = value
    }

    /**
     * @param value Whether the runner should ignore new jobs.
     */
    @JvmName("ukbrsphvneviagfl")
    public suspend fun paused(`value`: Output<Boolean>) {
        this.paused = value
    }

    /**
     * @param value The registration token used to register the runner.
     */
    @JvmName("kcijfocwwifrcowx")
    public suspend fun registrationToken(`value`: Output<String>) {
        this.registrationToken = value
    }

    /**
     * @param value Whether the runner should handle untagged jobs.
     */
    @JvmName("pnwdmhtkdschemfa")
    public suspend fun runUntagged(`value`: Output<Boolean>) {
        this.runUntagged = value
    }

    /**
     * @param value List of runner’s tags.
     */
    @JvmName("lhbntdkoaurkpuyl")
    public suspend fun tagLists(`value`: Output<List<String>>) {
        this.tagLists = value
    }

    @JvmName("odvjggnwciuptqbf")
    public suspend fun tagLists(vararg values: Output<String>) {
        this.tagLists = Output.all(values.asList())
    }

    /**
     * @param values List of runner’s tags.
     */
    @JvmName("rbrieltdtbifdhex")
    public suspend fun tagLists(values: List<Output<String>>) {
        this.tagLists = Output.all(values)
    }

    /**
     * @param value The access_level of the runner. Valid values are: `not_protected`, `ref_protected`.
     */
    @JvmName("icjfvjhsroillcbs")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value The runner's description.
     */
    @JvmName("kiisbyamyrhppbpx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the runner should be locked for current project.
     */
    @JvmName("rdtkilnrkrvuoydc")
    public suspend fun locked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locked = mapped
    }

    /**
     * @param value Maximum timeout set when this runner handles the job.
     */
    @JvmName("qynxcctambwoqsag")
    public suspend fun maximumTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumTimeout = mapped
    }

    /**
     * @param value Whether the runner should ignore new jobs.
     */
    @JvmName("ywtclasxuontmwhn")
    public suspend fun paused(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paused = mapped
    }

    /**
     * @param value The registration token used to register the runner.
     */
    @JvmName("waibjynubgmuowyv")
    public suspend fun registrationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationToken = mapped
    }

    /**
     * @param value Whether the runner should handle untagged jobs.
     */
    @JvmName("jbqvmoinbtgehrdo")
    public suspend fun runUntagged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runUntagged = mapped
    }

    /**
     * @param value List of runner’s tags.
     */
    @JvmName("kihdrwryljipwjca")
    public suspend fun tagLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagLists = mapped
    }

    /**
     * @param values List of runner’s tags.
     */
    @JvmName("goyjpwhqlfrdarty")
    public suspend fun tagLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagLists = mapped
    }

    internal fun build(): RunnerArgs = RunnerArgs(
        accessLevel = accessLevel,
        description = description,
        locked = locked,
        maximumTimeout = maximumTimeout,
        paused = paused,
        registrationToken = registrationToken,
        runUntagged = runUntagged,
        tagLists = tagLists,
    )
}
