@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceCustomIssueTracker].
 */
@PulumiTagMarker
public class ServiceCustomIssueTrackerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceCustomIssueTrackerArgs = ServiceCustomIssueTrackerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceCustomIssueTrackerArgsBuilder.() -> Unit) {
        val builder = ServiceCustomIssueTrackerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceCustomIssueTracker {
        val builtJavaResource = com.pulumi.gitlab.ServiceCustomIssueTracker(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceCustomIssueTracker(builtJavaResource)
    }
}

/**
 * The `gitlab.ServiceCustomIssueTracker` resource allows to manage the lifecycle of a project integration with Custom Issue Tracker.
 * > This resource is deprecated. use `gitlab.IntegrationCustomIssueTracker`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#custom-issue-tracker)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const tracker = new gitlab.ServiceCustomIssueTracker("tracker", {
 *     project: awesomeProject.id,
 *     projectUrl: "https://customtracker.com/issues",
 *     issuesUrl: "https://customtracker.com/TEST-:id",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * tracker = gitlab.ServiceCustomIssueTracker("tracker",
 *     project=awesome_project.id,
 *     project_url="https://customtracker.com/issues",
 *     issues_url="https://customtracker.com/TEST-:id")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var tracker = new GitLab.ServiceCustomIssueTracker("tracker", new()
 *     {
 *         Project = awesomeProject.Id,
 *         ProjectUrl = "https://customtracker.com/issues",
 *         IssuesUrl = "https://customtracker.com/TEST-:id",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceCustomIssueTracker(ctx, "tracker", &gitlab.ServiceCustomIssueTrackerArgs{
 * 			Project:    awesomeProject.ID(),
 * 			ProjectUrl: pulumi.String("https://customtracker.com/issues"),
 * 			IssuesUrl:  pulumi.String("https://customtracker.com/TEST-:id"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceCustomIssueTracker;
 * import com.pulumi.gitlab.ServiceCustomIssueTrackerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var tracker = new ServiceCustomIssueTracker("tracker", ServiceCustomIssueTrackerArgs.builder()
 *             .project(awesomeProject.id())
 *             .projectUrl("https://customtracker.com/issues")
 *             .issuesUrl("https://customtracker.com/TEST-:id")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   tracker:
 *     type: gitlab:ServiceCustomIssueTracker
 *     properties:
 *       project: ${awesomeProject.id}
 *       projectUrl: https://customtracker.com/issues
 *       issuesUrl: https://customtracker.com/TEST-:id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_custom_issue_tracker state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceCustomIssueTracker:ServiceCustomIssueTracker tracker 1
 * ```
 */
public class ServiceCustomIssueTracker internal constructor(
    override val javaResource: com.pulumi.gitlab.ServiceCustomIssueTracker,
) : KotlinCustomResource(javaResource, ServiceCustomIssueTrackerMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was activated at in UTC.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The URL to view an issue in the external issue tracker. Must contain :id.
     */
    public val issuesUrl: Output<String>
        get() = javaResource.issuesUrl().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project for the custom issue tracker.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The URL to the project in the external issue tracker.
     */
    public val projectUrl: Output<String>
        get() = javaResource.projectUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the integration in lowercase, shortened to 63 bytes, and with everything except 0-9 and a-z replaced with -. No leading / trailing -. Use in URLs, host names and domain names.
     */
    public val slug: Output<String>
        get() = javaResource.slug().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 date/time that this integration was last updated at in UTC.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object ServiceCustomIssueTrackerMapper : ResourceMapper<ServiceCustomIssueTracker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ServiceCustomIssueTracker::class == javaResource::class

    override fun map(javaResource: Resource): ServiceCustomIssueTracker =
        ServiceCustomIssueTracker(javaResource as com.pulumi.gitlab.ServiceCustomIssueTracker)
}

/**
 * @see [ServiceCustomIssueTracker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceCustomIssueTracker].
 */
public suspend fun serviceCustomIssueTracker(
    name: String,
    block: suspend ServiceCustomIssueTrackerResourceBuilder.() -> Unit,
): ServiceCustomIssueTracker {
    val builder = ServiceCustomIssueTrackerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceCustomIssueTracker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceCustomIssueTracker(name: String): ServiceCustomIssueTracker {
    val builder = ServiceCustomIssueTrackerResourceBuilder()
    builder.name(name)
    return builder.build()
}
