@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ServiceCustomIssueTrackerArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ServiceCustomIssueTracker` resource allows to manage the lifecycle of a project integration with Custom Issue Tracker.
 * > This resource is deprecated. use `gitlab.IntegrationCustomIssueTracker`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#custom-issue-tracker)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const tracker = new gitlab.ServiceCustomIssueTracker("tracker", {
 *     project: awesomeProject.id,
 *     projectUrl: "https://customtracker.com/issues",
 *     issuesUrl: "https://customtracker.com/TEST-:id",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * tracker = gitlab.ServiceCustomIssueTracker("tracker",
 *     project=awesome_project.id,
 *     project_url="https://customtracker.com/issues",
 *     issues_url="https://customtracker.com/TEST-:id")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var tracker = new GitLab.ServiceCustomIssueTracker("tracker", new()
 *     {
 *         Project = awesomeProject.Id,
 *         ProjectUrl = "https://customtracker.com/issues",
 *         IssuesUrl = "https://customtracker.com/TEST-:id",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceCustomIssueTracker(ctx, "tracker", &gitlab.ServiceCustomIssueTrackerArgs{
 * 			Project:    awesomeProject.ID(),
 * 			ProjectUrl: pulumi.String("https://customtracker.com/issues"),
 * 			IssuesUrl:  pulumi.String("https://customtracker.com/TEST-:id"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceCustomIssueTracker;
 * import com.pulumi.gitlab.ServiceCustomIssueTrackerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var tracker = new ServiceCustomIssueTracker("tracker", ServiceCustomIssueTrackerArgs.builder()
 *             .project(awesomeProject.id())
 *             .projectUrl("https://customtracker.com/issues")
 *             .issuesUrl("https://customtracker.com/TEST-:id")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   tracker:
 *     type: gitlab:ServiceCustomIssueTracker
 *     properties:
 *       project: ${awesomeProject.id}
 *       projectUrl: https://customtracker.com/issues
 *       issuesUrl: https://customtracker.com/TEST-:id
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_custom_issue_tracker state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceCustomIssueTracker:ServiceCustomIssueTracker tracker 1
 * ```
 * @property issuesUrl The URL to view an issue in the external issue tracker. Must contain :id.
 * @property project The ID or full path of the project for the custom issue tracker.
 * @property projectUrl The URL to the project in the external issue tracker.
 */
public data class ServiceCustomIssueTrackerArgs(
    public val issuesUrl: Output<String>? = null,
    public val project: Output<String>? = null,
    public val projectUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ServiceCustomIssueTrackerArgs> {
    override fun toJava(): com.pulumi.gitlab.ServiceCustomIssueTrackerArgs =
        com.pulumi.gitlab.ServiceCustomIssueTrackerArgs.builder()
            .issuesUrl(issuesUrl?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .projectUrl(projectUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceCustomIssueTrackerArgs].
 */
@PulumiTagMarker
public class ServiceCustomIssueTrackerArgsBuilder internal constructor() {
    private var issuesUrl: Output<String>? = null

    private var project: Output<String>? = null

    private var projectUrl: Output<String>? = null

    /**
     * @param value The URL to view an issue in the external issue tracker. Must contain :id.
     */
    @JvmName("lrulycjayfbmukgw")
    public suspend fun issuesUrl(`value`: Output<String>) {
        this.issuesUrl = value
    }

    /**
     * @param value The ID or full path of the project for the custom issue tracker.
     */
    @JvmName("kppukvygfsetekor")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The URL to the project in the external issue tracker.
     */
    @JvmName("rlyyhhutiohedboc")
    public suspend fun projectUrl(`value`: Output<String>) {
        this.projectUrl = value
    }

    /**
     * @param value The URL to view an issue in the external issue tracker. Must contain :id.
     */
    @JvmName("ajtbtwctqywaybwe")
    public suspend fun issuesUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesUrl = mapped
    }

    /**
     * @param value The ID or full path of the project for the custom issue tracker.
     */
    @JvmName("vabikidvdqldkapi")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The URL to the project in the external issue tracker.
     */
    @JvmName("ixkkgjomxiqrayrr")
    public suspend fun projectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectUrl = mapped
    }

    internal fun build(): ServiceCustomIssueTrackerArgs = ServiceCustomIssueTrackerArgs(
        issuesUrl = issuesUrl,
        project = project,
        projectUrl = projectUrl,
    )
}
