@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ServiceEmailsOnPushArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.ServiceEmailsOnPush` resource allows to manage the lifecycle of a project integration with Emails on Push Service.
 * > This resource is deprecated. Please use `gitlab.IntegrationEmailsOnPush` instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#emails-on-push)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const emails = new gitlab.ServiceEmailsOnPush("emails", {
 *     project: awesomeProject.id,
 *     recipients: "myrecipient@example.com myotherrecipient@example.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * emails = gitlab.ServiceEmailsOnPush("emails",
 *     project=awesome_project.id,
 *     recipients="myrecipient@example.com myotherrecipient@example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var emails = new GitLab.ServiceEmailsOnPush("emails", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Recipients = "myrecipient@example.com myotherrecipient@example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceEmailsOnPush(ctx, "emails", &gitlab.ServiceEmailsOnPushArgs{
 * 			Project:    awesomeProject.ID(),
 * 			Recipients: pulumi.String("myrecipient@example.com myotherrecipient@example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceEmailsOnPush;
 * import com.pulumi.gitlab.ServiceEmailsOnPushArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var emails = new ServiceEmailsOnPush("emails", ServiceEmailsOnPushArgs.builder()
 *             .project(awesomeProject.id())
 *             .recipients("myrecipient@example.com myotherrecipient@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   emails:
 *     type: gitlab:ServiceEmailsOnPush
 *     properties:
 *       project: ${awesomeProject.id}
 *       recipients: myrecipient@example.com myotherrecipient@example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_emails_on_push state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceEmailsOnPush:ServiceEmailsOnPush emails 1
 * ```
 * @property branchesToBeNotified Branches to send notifications for. Valid options are `all`, `default`, `protected`, `default_and_protected`. Notifications are always fired for tag pushes.
 * @property disableDiffs Disable code diffs.
 * @property project ID or full-path of the project you want to activate integration on.
 * @property pushEvents Enable notifications for push events.
 * @property recipients Emails separated by whitespace.
 * @property sendFromCommitterEmail Send from committer.
 * @property tagPushEvents Enable notifications for tag push events.
 */
public data class ServiceEmailsOnPushArgs(
    public val branchesToBeNotified: Output<String>? = null,
    public val disableDiffs: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val recipients: Output<String>? = null,
    public val sendFromCommitterEmail: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ServiceEmailsOnPushArgs> {
    override fun toJava(): com.pulumi.gitlab.ServiceEmailsOnPushArgs =
        com.pulumi.gitlab.ServiceEmailsOnPushArgs.builder()
            .branchesToBeNotified(branchesToBeNotified?.applyValue({ args0 -> args0 }))
            .disableDiffs(disableDiffs?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .recipients(recipients?.applyValue({ args0 -> args0 }))
            .sendFromCommitterEmail(sendFromCommitterEmail?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEmailsOnPushArgs].
 */
@PulumiTagMarker
public class ServiceEmailsOnPushArgsBuilder internal constructor() {
    private var branchesToBeNotified: Output<String>? = null

    private var disableDiffs: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var pushEvents: Output<Boolean>? = null

    private var recipients: Output<String>? = null

    private var sendFromCommitterEmail: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    /**
     * @param value Branches to send notifications for. Valid options are `all`, `default`, `protected`, `default_and_protected`. Notifications are always fired for tag pushes.
     */
    @JvmName("poccrtihklnqhpys")
    public suspend fun branchesToBeNotified(`value`: Output<String>) {
        this.branchesToBeNotified = value
    }

    /**
     * @param value Disable code diffs.
     */
    @JvmName("yuarsmuinnlptsjn")
    public suspend fun disableDiffs(`value`: Output<Boolean>) {
        this.disableDiffs = value
    }

    /**
     * @param value ID or full-path of the project you want to activate integration on.
     */
    @JvmName("jaerngqxfcjnrkoa")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("uieyrelelyhccvrd")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Emails separated by whitespace.
     */
    @JvmName("isgkhwhyhbkowkyj")
    public suspend fun recipients(`value`: Output<String>) {
        this.recipients = value
    }

    /**
     * @param value Send from committer.
     */
    @JvmName("evsjxvpxshomxvji")
    public suspend fun sendFromCommitterEmail(`value`: Output<Boolean>) {
        this.sendFromCommitterEmail = value
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("vqiamfyfayogxwiv")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value Branches to send notifications for. Valid options are `all`, `default`, `protected`, `default_and_protected`. Notifications are always fired for tag pushes.
     */
    @JvmName("egftugseihessivo")
    public suspend fun branchesToBeNotified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchesToBeNotified = mapped
    }

    /**
     * @param value Disable code diffs.
     */
    @JvmName("psgirmhsmpjcrodb")
    public suspend fun disableDiffs(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableDiffs = mapped
    }

    /**
     * @param value ID or full-path of the project you want to activate integration on.
     */
    @JvmName("giuvydepepseqjwr")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Enable notifications for push events.
     */
    @JvmName("wsanepvmgcyrmcfb")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Emails separated by whitespace.
     */
    @JvmName("yryhhewljiybwnle")
    public suspend fun recipients(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param value Send from committer.
     */
    @JvmName("wexudvgnyidvvohe")
    public suspend fun sendFromCommitterEmail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendFromCommitterEmail = mapped
    }

    /**
     * @param value Enable notifications for tag push events.
     */
    @JvmName("qqvxvbpnhxlnuspw")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    internal fun build(): ServiceEmailsOnPushArgs = ServiceEmailsOnPushArgs(
        branchesToBeNotified = branchesToBeNotified,
        disableDiffs = disableDiffs,
        project = project,
        pushEvents = pushEvents,
        recipients = recipients,
        sendFromCommitterEmail = sendFromCommitterEmail,
        tagPushEvents = tagPushEvents,
    )
}
