@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceGithub].
 */
@PulumiTagMarker
public class ServiceGithubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceGithubArgs = ServiceGithubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceGithubArgsBuilder.() -> Unit) {
        val builder = ServiceGithubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceGithub {
        val builtJavaResource = com.pulumi.gitlab.ServiceGithub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceGithub(builtJavaResource)
    }
}

/**
 * The `gitlab.ServiceGithub` resource allows to manage the lifecycle of a project integration with GitHub.
 * > This resource requires a GitLab Enterprise instance.
 * > This resource is deprecated. use `gitlab.IntegrationGithub`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#github)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const github = new gitlab.ServiceGithub("github", {
 *     project: awesomeProject.id,
 *     token: "REDACTED",
 *     repositoryUrl: "https://github.com/gitlabhq/terraform-provider-gitlab",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * github = gitlab.ServiceGithub("github",
 *     project=awesome_project.id,
 *     token="REDACTED",
 *     repository_url="https://github.com/gitlabhq/terraform-provider-gitlab")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var github = new GitLab.ServiceGithub("github", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Token = "REDACTED",
 *         RepositoryUrl = "https://github.com/gitlabhq/terraform-provider-gitlab",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceGithub(ctx, "github", &gitlab.ServiceGithubArgs{
 * 			Project:       awesomeProject.ID(),
 * 			Token:         pulumi.String("REDACTED"),
 * 			RepositoryUrl: pulumi.String("https://github.com/gitlabhq/terraform-provider-gitlab"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceGithub;
 * import com.pulumi.gitlab.ServiceGithubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var github = new ServiceGithub("github", ServiceGithubArgs.builder()
 *             .project(awesomeProject.id())
 *             .token("REDACTED")
 *             .repositoryUrl("https://github.com/gitlabhq/terraform-provider-gitlab")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   github:
 *     type: gitlab:ServiceGithub
 *     properties:
 *       project: ${awesomeProject.id}
 *       token: REDACTED
 *       repositoryUrl: https://github.com/gitlabhq/terraform-provider-gitlab
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/serviceGithub:ServiceGithub You can import a gitlab_service_github state using `<resource> <project_id>`:
 * ```
 * ```sh
 * $ pulumi import gitlab:index/serviceGithub:ServiceGithub github 1
 * ```
 */
public class ServiceGithub internal constructor(
    override val javaResource: com.pulumi.gitlab.ServiceGithub,
) : KotlinCustomResource(javaResource, ServiceGithubMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    public val repositoryUrl: Output<String>
        get() = javaResource.repositoryUrl().applyValue({ args0 -> args0 })

    /**
     * Append instance name instead of branch to the status. Must enable to set a GitLab status check as *required* in GitHub. See [Static / dynamic status check names] to learn more.
     */
    public val staticContext: Output<Boolean>?
        get() = javaResource.staticContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * A GitHub personal access token with at least `repo:status` scope.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * Update time.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object ServiceGithubMapper : ResourceMapper<ServiceGithub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ServiceGithub::class == javaResource::class

    override fun map(javaResource: Resource): ServiceGithub = ServiceGithub(
        javaResource as
            com.pulumi.gitlab.ServiceGithub,
    )
}

/**
 * @see [ServiceGithub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceGithub].
 */
public suspend fun serviceGithub(
    name: String,
    block: suspend ServiceGithubResourceBuilder.() -> Unit,
): ServiceGithub {
    val builder = ServiceGithubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceGithub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceGithub(name: String): ServiceGithub {
    val builder = ServiceGithubResourceBuilder()
    builder.name(name)
    return builder.build()
}
