@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ServiceJira].
 */
@PulumiTagMarker
public class ServiceJiraResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceJiraArgs = ServiceJiraArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceJiraArgsBuilder.() -> Unit) {
        val builder = ServiceJiraArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceJira {
        val builtJavaResource = com.pulumi.gitlab.ServiceJira(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceJira(builtJavaResource)
    }
}

/**
 * The `gitlab.ServiceJira` resource allows to manage the lifecycle of a project integration with Jira.
 * > This resource is deprecated. use `gitlab.IntegrationJira`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jira)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const jira = new gitlab.ServiceJira("jira", {
 *     project: awesomeProject.id,
 *     url: "https://jira.example.com",
 *     username: "user",
 *     password: "mypass",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * jira = gitlab.ServiceJira("jira",
 *     project=awesome_project.id,
 *     url="https://jira.example.com",
 *     username="user",
 *     password="mypass")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var jira = new GitLab.ServiceJira("jira", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Url = "https://jira.example.com",
 *         Username = "user",
 *         Password = "mypass",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceJira(ctx, "jira", &gitlab.ServiceJiraArgs{
 * 			Project:  awesomeProject.ID(),
 * 			Url:      pulumi.String("https://jira.example.com"),
 * 			Username: pulumi.String("user"),
 * 			Password: pulumi.String("mypass"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceJira;
 * import com.pulumi.gitlab.ServiceJiraArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var jira = new ServiceJira("jira", ServiceJiraArgs.builder()
 *             .project(awesomeProject.id())
 *             .url("https://jira.example.com")
 *             .username("user")
 *             .password("mypass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   jira:
 *     type: gitlab:ServiceJira
 *     properties:
 *       project: ${awesomeProject.id}
 *       url: https://jira.example.com
 *       username: user
 *       password: mypass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_jira state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceJira:ServiceJira jira 1
 * ```
 */
public class ServiceJira internal constructor(
    override val javaResource: com.pulumi.gitlab.ServiceJira,
) : KotlinCustomResource(javaResource, ServiceJiraMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
     */
    public val apiUrl: Output<String>
        get() = javaResource.apiUrl().applyValue({ args0 -> args0 })

    /**
     * Enable comments inside Jira issues on each GitLab event (commit / merge request)
     */
    public val commentOnEventEnabled: Output<Boolean>?
        get() = javaResource.commentOnEventEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for commit events
     */
    public val commitEvents: Output<Boolean>
        get() = javaResource.commitEvents().applyValue({ args0 -> args0 })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Enable viewing Jira issues in GitLab.
     */
    public val issuesEnabled: Output<Boolean>?
        get() = javaResource.issuesEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
     */
    public val jiraAuthType: Output<Int>?
        get() = javaResource.jiraAuthType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Prefix to match Jira issue keys.
     */
    public val jiraIssuePrefix: Output<String>?
        get() = javaResource.jiraIssuePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Regular expression to match Jira issue keys.
     */
    public val jiraIssueRegex: Output<String>?
        get() = javaResource.jiraIssueRegex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable automatic issue transitions. Takes precedence over jira*issue*transition_id if enabled. Defaults to false.
     */
    public val jiraIssueTransitionAutomatic: Output<Boolean>?
        get() = javaResource.jiraIssueTransitionAutomatic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
     */
    public val jiraIssueTransitionId: Output<String>?
        get() = javaResource.jiraIssueTransitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for merge request events
     */
    public val mergeRequestsEvents: Output<Boolean>
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 -> args0 })

    /**
     * The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The short identifier for your JIRA project, all uppercase, e.g., PROJ.
     */
    public val projectKey: Output<String>?
        get() = javaResource.projectKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
     */
    public val projectKeys: Output<List<String>>?
        get() = javaResource.projectKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * Update time.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * Indicates whether or not to inherit default settings. Defaults to false.
     */
    public val useInheritedSettings: Output<Boolean>?
        get() = javaResource.useInheritedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
     */
    public val username: Output<String>?
        get() = javaResource.username().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ServiceJiraMapper : ResourceMapper<ServiceJira> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ServiceJira::class == javaResource::class

    override fun map(javaResource: Resource): ServiceJira = ServiceJira(
        javaResource as
            com.pulumi.gitlab.ServiceJira,
    )
}

/**
 * @see [ServiceJira].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceJira].
 */
public suspend fun serviceJira(name: String, block: suspend ServiceJiraResourceBuilder.() -> Unit): ServiceJira {
    val builder = ServiceJiraResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceJira].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceJira(name: String): ServiceJira {
    val builder = ServiceJiraResourceBuilder()
    builder.name(name)
    return builder.build()
}
