@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ServiceJiraArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.ServiceJira` resource allows to manage the lifecycle of a project integration with Jira.
 * > This resource is deprecated. use `gitlab.IntegrationJira`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#jira)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const jira = new gitlab.ServiceJira("jira", {
 *     project: awesomeProject.id,
 *     url: "https://jira.example.com",
 *     username: "user",
 *     password: "mypass",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * jira = gitlab.ServiceJira("jira",
 *     project=awesome_project.id,
 *     url="https://jira.example.com",
 *     username="user",
 *     password="mypass")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var jira = new GitLab.ServiceJira("jira", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Url = "https://jira.example.com",
 *         Username = "user",
 *         Password = "mypass",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceJira(ctx, "jira", &gitlab.ServiceJiraArgs{
 * 			Project:  awesomeProject.ID(),
 * 			Url:      pulumi.String("https://jira.example.com"),
 * 			Username: pulumi.String("user"),
 * 			Password: pulumi.String("mypass"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceJira;
 * import com.pulumi.gitlab.ServiceJiraArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var jira = new ServiceJira("jira", ServiceJiraArgs.builder()
 *             .project(awesomeProject.id())
 *             .url("https://jira.example.com")
 *             .username("user")
 *             .password("mypass")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   jira:
 *     type: gitlab:ServiceJira
 *     properties:
 *       project: ${awesomeProject.id}
 *       url: https://jira.example.com
 *       username: user
 *       password: mypass
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_jira state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceJira:ServiceJira jira 1
 * ```
 * @property apiUrl The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
 * @property commentOnEventEnabled Enable comments inside Jira issues on each GitLab event (commit / merge request)
 * @property commitEvents Enable notifications for commit events
 * @property issuesEnabled Enable viewing Jira issues in GitLab.
 * @property jiraAuthType The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
 * @property jiraIssuePrefix Prefix to match Jira issue keys.
 * @property jiraIssueRegex Regular expression to match Jira issue keys.
 * @property jiraIssueTransitionAutomatic Enable automatic issue transitions. Takes precedence over jira*issue*transition_id if enabled. Defaults to false.
 * @property jiraIssueTransitionId The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
 * @property mergeRequestsEvents Enable notifications for merge request events
 * @property password The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
 * @property project ID of the project you want to activate integration on.
 * @property projectKey The short identifier for your JIRA project, all uppercase, e.g., PROJ.
 * @property projectKeys Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
 * @property url The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
 * @property useInheritedSettings Indicates whether or not to inherit default settings. Defaults to false.
 * @property username The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
 */
public data class ServiceJiraArgs(
    public val apiUrl: Output<String>? = null,
    public val commentOnEventEnabled: Output<Boolean>? = null,
    public val commitEvents: Output<Boolean>? = null,
    public val issuesEnabled: Output<Boolean>? = null,
    public val jiraAuthType: Output<Int>? = null,
    public val jiraIssuePrefix: Output<String>? = null,
    public val jiraIssueRegex: Output<String>? = null,
    public val jiraIssueTransitionAutomatic: Output<Boolean>? = null,
    public val jiraIssueTransitionId: Output<String>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val project: Output<String>? = null,
    public val projectKey: Output<String>? = null,
    public val projectKeys: Output<List<String>>? = null,
    public val url: Output<String>? = null,
    public val useInheritedSettings: Output<Boolean>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ServiceJiraArgs> {
    override fun toJava(): com.pulumi.gitlab.ServiceJiraArgs =
        com.pulumi.gitlab.ServiceJiraArgs.builder()
            .apiUrl(apiUrl?.applyValue({ args0 -> args0 }))
            .commentOnEventEnabled(commentOnEventEnabled?.applyValue({ args0 -> args0 }))
            .commitEvents(commitEvents?.applyValue({ args0 -> args0 }))
            .issuesEnabled(issuesEnabled?.applyValue({ args0 -> args0 }))
            .jiraAuthType(jiraAuthType?.applyValue({ args0 -> args0 }))
            .jiraIssuePrefix(jiraIssuePrefix?.applyValue({ args0 -> args0 }))
            .jiraIssueRegex(jiraIssueRegex?.applyValue({ args0 -> args0 }))
            .jiraIssueTransitionAutomatic(jiraIssueTransitionAutomatic?.applyValue({ args0 -> args0 }))
            .jiraIssueTransitionId(jiraIssueTransitionId?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .projectKey(projectKey?.applyValue({ args0 -> args0 }))
            .projectKeys(projectKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .url(url?.applyValue({ args0 -> args0 }))
            .useInheritedSettings(useInheritedSettings?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceJiraArgs].
 */
@PulumiTagMarker
public class ServiceJiraArgsBuilder internal constructor() {
    private var apiUrl: Output<String>? = null

    private var commentOnEventEnabled: Output<Boolean>? = null

    private var commitEvents: Output<Boolean>? = null

    private var issuesEnabled: Output<Boolean>? = null

    private var jiraAuthType: Output<Int>? = null

    private var jiraIssuePrefix: Output<String>? = null

    private var jiraIssueRegex: Output<String>? = null

    private var jiraIssueTransitionAutomatic: Output<Boolean>? = null

    private var jiraIssueTransitionId: Output<String>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var project: Output<String>? = null

    private var projectKey: Output<String>? = null

    private var projectKeys: Output<List<String>>? = null

    private var url: Output<String>? = null

    private var useInheritedSettings: Output<Boolean>? = null

    private var username: Output<String>? = null

    /**
     * @param value The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
     */
    @JvmName("huknsdsuspxuyxuq")
    public suspend fun apiUrl(`value`: Output<String>) {
        this.apiUrl = value
    }

    /**
     * @param value Enable comments inside Jira issues on each GitLab event (commit / merge request)
     */
    @JvmName("auyqlosfuttontag")
    public suspend fun commentOnEventEnabled(`value`: Output<Boolean>) {
        this.commentOnEventEnabled = value
    }

    /**
     * @param value Enable notifications for commit events
     */
    @JvmName("twqseaojyakbnumt")
    public suspend fun commitEvents(`value`: Output<Boolean>) {
        this.commitEvents = value
    }

    /**
     * @param value Enable viewing Jira issues in GitLab.
     */
    @JvmName("hrgpyenweeacerdo")
    public suspend fun issuesEnabled(`value`: Output<Boolean>) {
        this.issuesEnabled = value
    }

    /**
     * @param value The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
     */
    @JvmName("pjcfpnesarlffnis")
    public suspend fun jiraAuthType(`value`: Output<Int>) {
        this.jiraAuthType = value
    }

    /**
     * @param value Prefix to match Jira issue keys.
     */
    @JvmName("vssclpbrgsduchbk")
    public suspend fun jiraIssuePrefix(`value`: Output<String>) {
        this.jiraIssuePrefix = value
    }

    /**
     * @param value Regular expression to match Jira issue keys.
     */
    @JvmName("ecuwlsrurierolqq")
    public suspend fun jiraIssueRegex(`value`: Output<String>) {
        this.jiraIssueRegex = value
    }

    /**
     * @param value Enable automatic issue transitions. Takes precedence over jira*issue*transition_id if enabled. Defaults to false.
     */
    @JvmName("vgnldcfmmfrviuyp")
    public suspend fun jiraIssueTransitionAutomatic(`value`: Output<Boolean>) {
        this.jiraIssueTransitionAutomatic = value
    }

    /**
     * @param value The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
     */
    @JvmName("wfrkojbkefexrnqb")
    public suspend fun jiraIssueTransitionId(`value`: Output<String>) {
        this.jiraIssueTransitionId = value
    }

    /**
     * @param value Enable notifications for merge request events
     */
    @JvmName("tsvofydivymumrsh")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
     */
    @JvmName("smllmsojvyaopuck")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("pjssbxnyahuyfyfg")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The short identifier for your JIRA project, all uppercase, e.g., PROJ.
     */
    @JvmName("rgwcduqyialqwoli")
    public suspend fun projectKey(`value`: Output<String>) {
        this.projectKey = value
    }

    /**
     * @param value Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
     */
    @JvmName("hhebvofuxqfrxxop")
    public suspend fun projectKeys(`value`: Output<List<String>>) {
        this.projectKeys = value
    }

    @JvmName("sehuwwblfxrtnyci")
    public suspend fun projectKeys(vararg values: Output<String>) {
        this.projectKeys = Output.all(values.asList())
    }

    /**
     * @param values Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
     */
    @JvmName("sljaqkpichdiaisc")
    public suspend fun projectKeys(values: List<Output<String>>) {
        this.projectKeys = Output.all(values)
    }

    /**
     * @param value The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
     */
    @JvmName("ngclknwugjqmcgrx")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Indicates whether or not to inherit default settings. Defaults to false.
     */
    @JvmName("nsdbjpxvymuiyrmo")
    public suspend fun useInheritedSettings(`value`: Output<Boolean>) {
        this.useInheritedSettings = value
    }

    /**
     * @param value The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
     */
    @JvmName("inxllpkqihngtlqg")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The base URL to the Jira instance API. Web URL value is used if not set. For example, https://jira-api.example.com.
     */
    @JvmName("ocpbfaradndykgwm")
    public suspend fun apiUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiUrl = mapped
    }

    /**
     * @param value Enable comments inside Jira issues on each GitLab event (commit / merge request)
     */
    @JvmName("pbbudcveebxxmvbm")
    public suspend fun commentOnEventEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commentOnEventEnabled = mapped
    }

    /**
     * @param value Enable notifications for commit events
     */
    @JvmName("ssyfwcfthkfbmmrq")
    public suspend fun commitEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitEvents = mapped
    }

    /**
     * @param value Enable viewing Jira issues in GitLab.
     */
    @JvmName("nhewrgctweualoay")
    public suspend fun issuesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEnabled = mapped
    }

    /**
     * @param value The authentication method to be used with Jira. 0 means Basic Authentication. 1 means Jira personal access token. Defaults to 0.
     */
    @JvmName("fsmilxxktxsmlaot")
    public suspend fun jiraAuthType(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jiraAuthType = mapped
    }

    /**
     * @param value Prefix to match Jira issue keys.
     */
    @JvmName("sxqriktyvsvyjasq")
    public suspend fun jiraIssuePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jiraIssuePrefix = mapped
    }

    /**
     * @param value Regular expression to match Jira issue keys.
     */
    @JvmName("ovhhjhyqajgddijt")
    public suspend fun jiraIssueRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jiraIssueRegex = mapped
    }

    /**
     * @param value Enable automatic issue transitions. Takes precedence over jira*issue*transition_id if enabled. Defaults to false.
     */
    @JvmName("xlcyvmcligvyfavk")
    public suspend fun jiraIssueTransitionAutomatic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jiraIssueTransitionAutomatic = mapped
    }

    /**
     * @param value The ID of a transition that moves issues to a closed state. You can find this number under the JIRA workflow administration (Administration > Issues > Workflows) by selecting View under Operations of the desired workflow of your project. By default, this ID is set to 2. *Note**: importing this field is only supported since GitLab 15.2.
     */
    @JvmName("kwsmyufvstxtaofk")
    public suspend fun jiraIssueTransitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jiraIssueTransitionId = mapped
    }

    /**
     * @param value Enable notifications for merge request events
     */
    @JvmName("vndhfluubiegusjy")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value The Jira API token, password, or personal access token to be used with Jira. When your authentication method is basic (jira*auth*type is 0), use an API token for Jira Cloud or a password for Jira Data Center or Jira Server. When your authentication method is a Jira personal access token (jira*auth*type is 1), use the personal access token.
     */
    @JvmName("hfnwvuxcbpyvxkps")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("yhsqkxiqmgdlonpb")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The short identifier for your JIRA project, all uppercase, e.g., PROJ.
     */
    @JvmName("smxjnlijxdvdvsqn")
    public suspend fun projectKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectKey = mapped
    }

    /**
     * @param value Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
     */
    @JvmName("dwtlihhdmqcuoaax")
    public suspend fun projectKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectKeys = mapped
    }

    /**
     * @param values Keys of Jira projects. When issues_enabled is true, this setting specifies which Jira projects to view issues from in GitLab.
     */
    @JvmName("malkmhudejvwvnxv")
    public suspend fun projectKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectKeys = mapped
    }

    /**
     * @param value The URL to the JIRA project which is being linked to this GitLab project. For example, https://jira.example.com.
     */
    @JvmName("nonatcyfqcbhifhi")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Indicates whether or not to inherit default settings. Defaults to false.
     */
    @JvmName("fgscqdfdwdkdwxve")
    public suspend fun useInheritedSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useInheritedSettings = mapped
    }

    /**
     * @param value The email or username to be used with Jira. For Jira Cloud use an email, for Jira Data Center and Jira Server use a username. Required when using Basic authentication (jira*auth*type is 0).
     */
    @JvmName("gmsqwmcjysdakjpp")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ServiceJiraArgs = ServiceJiraArgs(
        apiUrl = apiUrl,
        commentOnEventEnabled = commentOnEventEnabled,
        commitEvents = commitEvents,
        issuesEnabled = issuesEnabled,
        jiraAuthType = jiraAuthType,
        jiraIssuePrefix = jiraIssuePrefix,
        jiraIssueRegex = jiraIssueRegex,
        jiraIssueTransitionAutomatic = jiraIssueTransitionAutomatic,
        jiraIssueTransitionId = jiraIssueTransitionId,
        mergeRequestsEvents = mergeRequestsEvents,
        password = password,
        project = project,
        projectKey = projectKey,
        projectKeys = projectKeys,
        url = url,
        useInheritedSettings = useInheritedSettings,
        username = username,
    )
}
