@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServiceMicrosoftTeams].
 */
@PulumiTagMarker
public class ServiceMicrosoftTeamsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceMicrosoftTeamsArgs = ServiceMicrosoftTeamsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceMicrosoftTeamsArgsBuilder.() -> Unit) {
        val builder = ServiceMicrosoftTeamsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceMicrosoftTeams {
        val builtJavaResource = com.pulumi.gitlab.ServiceMicrosoftTeams(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceMicrosoftTeams(builtJavaResource)
    }
}

/**
 * The `gitlab.ServiceMicrosoftTeams` resource allows to manage the lifecycle of a project integration with Microsoft Teams.
 * > This resource is deprecated. use `gitlab.IntegrationMicrosoftTeams`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#microsoft-teams)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const teams = new gitlab.ServiceMicrosoftTeams("teams", {
 *     project: awesomeProject.id,
 *     webhook: "https://testurl.com/?token=XYZ",
 *     pushEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * teams = gitlab.ServiceMicrosoftTeams("teams",
 *     project=awesome_project.id,
 *     webhook="https://testurl.com/?token=XYZ",
 *     push_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var teams = new GitLab.ServiceMicrosoftTeams("teams", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Webhook = "https://testurl.com/?token=XYZ",
 *         PushEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServiceMicrosoftTeams(ctx, "teams", &gitlab.ServiceMicrosoftTeamsArgs{
 * 			Project:    awesomeProject.ID(),
 * 			Webhook:    pulumi.String("https://testurl.com/?token=XYZ"),
 * 			PushEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServiceMicrosoftTeams;
 * import com.pulumi.gitlab.ServiceMicrosoftTeamsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var teams = new ServiceMicrosoftTeams("teams", ServiceMicrosoftTeamsArgs.builder()
 *             .project(awesomeProject.id())
 *             .webhook("https://testurl.com/?token=XYZ")
 *             .pushEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   teams:
 *     type: gitlab:ServiceMicrosoftTeams
 *     properties:
 *       project: ${awesomeProject.id}
 *       webhook: https://testurl.com/?token=XYZ
 *       pushEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_microsoft_teams state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/serviceMicrosoftTeams:ServiceMicrosoftTeams teams 1
 * ```
 */
public class ServiceMicrosoftTeams internal constructor(
    override val javaResource: com.pulumi.gitlab.ServiceMicrosoftTeams,
) : KotlinCustomResource(javaResource, ServiceMicrosoftTeamsMapper) {
    /**
     * Whether the integration is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Branches to send notifications for. Valid options are “all”, “default”, “protected”, and “default*and*protected”. The default value is “default”
     */
    public val branchesToBeNotified: Output<String>?
        get() = javaResource.branchesToBeNotified().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential issue events
     */
    public val confidentialIssuesEvents: Output<Boolean>?
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for confidential note events
     */
    public val confidentialNoteEvents: Output<Boolean>?
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for issue events
     */
    public val issuesEvents: Output<Boolean>?
        get() = javaResource.issuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for merge request events
     */
    public val mergeRequestsEvents: Output<Boolean>?
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for note events
     */
    public val noteEvents: Output<Boolean>?
        get() = javaResource.noteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Send notifications for broken pipelines
     */
    public val notifyOnlyBrokenPipelines: Output<Boolean>?
        get() = javaResource.notifyOnlyBrokenPipelines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for pipeline events
     */
    public val pipelineEvents: Output<Boolean>?
        get() = javaResource.pipelineEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the project you want to activate integration on.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push events
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable notifications for tag push events
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Update time.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * The Microsoft Teams webhook (Example, https://outlook.office.com/webhook/...). This value cannot be imported.
     */
    public val webhook: Output<String>
        get() = javaResource.webhook().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for wiki page events
     */
    public val wikiPageEvents: Output<Boolean>?
        get() = javaResource.wikiPageEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ServiceMicrosoftTeamsMapper : ResourceMapper<ServiceMicrosoftTeams> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ServiceMicrosoftTeams::class == javaResource::class

    override fun map(javaResource: Resource): ServiceMicrosoftTeams =
        ServiceMicrosoftTeams(javaResource as com.pulumi.gitlab.ServiceMicrosoftTeams)
}

/**
 * @see [ServiceMicrosoftTeams].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceMicrosoftTeams].
 */
public suspend fun serviceMicrosoftTeams(
    name: String,
    block: suspend ServiceMicrosoftTeamsResourceBuilder.() -> Unit,
): ServiceMicrosoftTeams {
    val builder = ServiceMicrosoftTeamsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceMicrosoftTeams].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceMicrosoftTeams(name: String): ServiceMicrosoftTeams {
    val builder = ServiceMicrosoftTeamsResourceBuilder()
    builder.name(name)
    return builder.build()
}
