@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ServicePipelinesEmailArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.ServicePipelinesEmail` resource allows to manage the lifecycle of a project integration with Pipeline Emails Service.
 * > This resource is deprecated. use `gitlab.IntegrationPipelinesEmail`instead!
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/integrations.html#pipeline-emails)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const awesomeProject = new gitlab.Project("awesome_project", {
 *     name: "awesome_project",
 *     description: "My awesome project.",
 *     visibilityLevel: "public",
 * });
 * const email = new gitlab.ServicePipelinesEmail("email", {
 *     project: awesomeProject.id,
 *     recipients: ["gitlab@user&#46;create"],
 *     notifyOnlyBrokenPipelines: true,
 *     branchesToBeNotified: "all",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * awesome_project = gitlab.Project("awesome_project",
 *     name="awesome_project",
 *     description="My awesome project.",
 *     visibility_level="public")
 * email = gitlab.ServicePipelinesEmail("email",
 *     project=awesome_project.id,
 *     recipients=["gitlab@user&#46;create"],
 *     notify_only_broken_pipelines=True,
 *     branches_to_be_notified="all")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var awesomeProject = new GitLab.Project("awesome_project", new()
 *     {
 *         Name = "awesome_project",
 *         Description = "My awesome project.",
 *         VisibilityLevel = "public",
 *     });
 *     var email = new GitLab.ServicePipelinesEmail("email", new()
 *     {
 *         Project = awesomeProject.Id,
 *         Recipients = new[]
 *         {
 *             "gitlab@user.create",
 *         },
 *         NotifyOnlyBrokenPipelines = true,
 *         BranchesToBeNotified = "all",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		awesomeProject, err := gitlab.NewProject(ctx, "awesome_project", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("awesome_project"),
 * 			Description:     pulumi.String("My awesome project."),
 * 			VisibilityLevel: pulumi.String("public"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewServicePipelinesEmail(ctx, "email", &gitlab.ServicePipelinesEmailArgs{
 * 			Project: awesomeProject.ID(),
 * 			Recipients: pulumi.StringArray{
 * 				pulumi.String("gitlab@user.create"),
 * 			},
 * 			NotifyOnlyBrokenPipelines: pulumi.Bool(true),
 * 			BranchesToBeNotified:      pulumi.String("all"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.ServicePipelinesEmail;
 * import com.pulumi.gitlab.ServicePipelinesEmailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var awesomeProject = new Project("awesomeProject", ProjectArgs.builder()
 *             .name("awesome_project")
 *             .description("My awesome project.")
 *             .visibilityLevel("public")
 *             .build());
 *         var email = new ServicePipelinesEmail("email", ServicePipelinesEmailArgs.builder()
 *             .project(awesomeProject.id())
 *             .recipients("gitlab@user.create")
 *             .notifyOnlyBrokenPipelines(true)
 *             .branchesToBeNotified("all")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   awesomeProject:
 *     type: gitlab:Project
 *     name: awesome_project
 *     properties:
 *       name: awesome_project
 *       description: My awesome project.
 *       visibilityLevel: public
 *   email:
 *     type: gitlab:ServicePipelinesEmail
 *     properties:
 *       project: ${awesomeProject.id}
 *       recipients:
 *         - gitlab@user.create
 *       notifyOnlyBrokenPipelines: true
 *       branchesToBeNotified: all
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab_service_pipelines_email state using the project ID, e.g.
 * ```sh
 * $ pulumi import gitlab:index/servicePipelinesEmail:ServicePipelinesEmail email 1
 * ```
 * @property branchesToBeNotified Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
 * @property notifyOnlyBrokenPipelines Notify only broken pipelines. Default is true.
 * @property project ID of the project you want to activate integration on.
 * @property recipients ) email addresses where notifications are sent.
 */
public data class ServicePipelinesEmailArgs(
    public val branchesToBeNotified: Output<String>? = null,
    public val notifyOnlyBrokenPipelines: Output<Boolean>? = null,
    public val project: Output<String>? = null,
    public val recipients: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ServicePipelinesEmailArgs> {
    override fun toJava(): com.pulumi.gitlab.ServicePipelinesEmailArgs =
        com.pulumi.gitlab.ServicePipelinesEmailArgs.builder()
            .branchesToBeNotified(branchesToBeNotified?.applyValue({ args0 -> args0 }))
            .notifyOnlyBrokenPipelines(notifyOnlyBrokenPipelines?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .recipients(recipients?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServicePipelinesEmailArgs].
 */
@PulumiTagMarker
public class ServicePipelinesEmailArgsBuilder internal constructor() {
    private var branchesToBeNotified: Output<String>? = null

    private var notifyOnlyBrokenPipelines: Output<Boolean>? = null

    private var project: Output<String>? = null

    private var recipients: Output<List<String>>? = null

    /**
     * @param value Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
     */
    @JvmName("bvqyjcvsuehbtmsr")
    public suspend fun branchesToBeNotified(`value`: Output<String>) {
        this.branchesToBeNotified = value
    }

    /**
     * @param value Notify only broken pipelines. Default is true.
     */
    @JvmName("wgrkmdettnwciwnj")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Output<Boolean>) {
        this.notifyOnlyBrokenPipelines = value
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("ihwpyvmqlowighat")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value ) email addresses where notifications are sent.
     */
    @JvmName("fevyyjmtlamnugvv")
    public suspend fun recipients(`value`: Output<List<String>>) {
        this.recipients = value
    }

    @JvmName("bufavgxvyhpvntdb")
    public suspend fun recipients(vararg values: Output<String>) {
        this.recipients = Output.all(values.asList())
    }

    /**
     * @param values ) email addresses where notifications are sent.
     */
    @JvmName("orvrhdoyfntweyvo")
    public suspend fun recipients(values: List<Output<String>>) {
        this.recipients = Output.all(values)
    }

    /**
     * @param value Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
     */
    @JvmName("abkucbpqvbihlspo")
    public suspend fun branchesToBeNotified(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchesToBeNotified = mapped
    }

    /**
     * @param value Notify only broken pipelines. Default is true.
     */
    @JvmName("stwxgsebvfuhpwlr")
    public suspend fun notifyOnlyBrokenPipelines(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyOnlyBrokenPipelines = mapped
    }

    /**
     * @param value ID of the project you want to activate integration on.
     */
    @JvmName("qpquliowgyxhqfac")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value ) email addresses where notifications are sent.
     */
    @JvmName("iruvjoelhwncukyj")
    public suspend fun recipients(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    /**
     * @param values ) email addresses where notifications are sent.
     */
    @JvmName("qmhigiljqxrxuoai")
    public suspend fun recipients(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recipients = mapped
    }

    internal fun build(): ServicePipelinesEmailArgs = ServicePipelinesEmailArgs(
        branchesToBeNotified = branchesToBeNotified,
        notifyOnlyBrokenPipelines = notifyOnlyBrokenPipelines,
        project = project,
        recipients = recipients,
    )
}
