@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SystemHook].
 */
@PulumiTagMarker
public class SystemHookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SystemHookArgs = SystemHookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SystemHookArgsBuilder.() -> Unit) {
        val builder = SystemHookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SystemHook {
        val builtJavaResource = com.pulumi.gitlab.SystemHook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SystemHook(builtJavaResource)
    }
}

/**
 * The `gitlab.SystemHook` resource allows to manage the lifecycle of a system hook.
 * > This resource requires GitLab 14.9
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/system_hooks.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.SystemHook("example", {
 *     url: "https://example.com/hook-%d",
 *     token: "secret-token",
 *     pushEvents: true,
 *     tagPushEvents: true,
 *     mergeRequestsEvents: true,
 *     repositoryUpdateEvents: true,
 *     enableSslVerification: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.SystemHook("example",
 *     url="https://example.com/hook-%d",
 *     token="secret-token",
 *     push_events=True,
 *     tag_push_events=True,
 *     merge_requests_events=True,
 *     repository_update_events=True,
 *     enable_ssl_verification=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.SystemHook("example", new()
 *     {
 *         Url = "https://example.com/hook-%d",
 *         Token = "secret-token",
 *         PushEvents = true,
 *         TagPushEvents = true,
 *         MergeRequestsEvents = true,
 *         RepositoryUpdateEvents = true,
 *         EnableSslVerification = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewSystemHook(ctx, "example", &gitlab.SystemHookArgs{
 * 			Url:                    pulumi.String("https://example.com/hook-%d"),
 * 			Token:                  pulumi.String("secret-token"),
 * 			PushEvents:             pulumi.Bool(true),
 * 			TagPushEvents:          pulumi.Bool(true),
 * 			MergeRequestsEvents:    pulumi.Bool(true),
 * 			RepositoryUpdateEvents: pulumi.Bool(true),
 * 			EnableSslVerification:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.SystemHook;
 * import com.pulumi.gitlab.SystemHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SystemHook("example", SystemHookArgs.builder()
 *             .url("https://example.com/hook-%d")
 *             .token("secret-token")
 *             .pushEvents(true)
 *             .tagPushEvents(true)
 *             .mergeRequestsEvents(true)
 *             .repositoryUpdateEvents(true)
 *             .enableSslVerification(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:SystemHook
 *     properties:
 *       url: https://example.com/hook-%d
 *       token: secret-token
 *       pushEvents: true
 *       tagPushEvents: true
 *       mergeRequestsEvents: true
 *       repositoryUpdateEvents: true
 *       enableSslVerification: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a system hook using the hook id `{hook-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/systemHook:SystemHook example 42
 * ```
 * NOTE: the `token` attribute won't be available for imported resources.
 */
public class SystemHook internal constructor(
    override val javaResource: com.pulumi.gitlab.SystemHook,
) : KotlinCustomResource(javaResource, SystemHookMapper) {
    /**
     * The date and time the hook was created in ISO8601 format.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Do SSL verification when triggering the hook.
     */
    public val enableSslVerification: Output<Boolean>?
        get() = javaResource.enableSslVerification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trigger hook on merge requests events.
     */
    public val mergeRequestsEvents: Output<Boolean>?
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When true, the hook fires on push events.
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trigger hook on repository update events.
     */
    public val repositoryUpdateEvents: Output<Boolean>?
        get() = javaResource.repositoryUpdateEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When true, the hook fires on new tags being pushed.
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Secret token to validate received payloads; this isn’t returned in the response. This attribute is not available for imported resources.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The hook URL.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object SystemHookMapper : ResourceMapper<SystemHook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.SystemHook::class == javaResource::class

    override fun map(javaResource: Resource): SystemHook = SystemHook(
        javaResource as
            com.pulumi.gitlab.SystemHook,
    )
}

/**
 * @see [SystemHook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SystemHook].
 */
public suspend fun systemHook(name: String, block: suspend SystemHookResourceBuilder.() -> Unit): SystemHook {
    val builder = SystemHookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SystemHook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun systemHook(name: String): SystemHook {
    val builder = SystemHookResourceBuilder()
    builder.name(name)
    return builder.build()
}
