@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.SystemHookArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.SystemHook` resource allows to manage the lifecycle of a system hook.
 * > This resource requires GitLab 14.9
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/system_hooks.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.SystemHook("example", {
 *     url: "https://example.com/hook-%d",
 *     token: "secret-token",
 *     pushEvents: true,
 *     tagPushEvents: true,
 *     mergeRequestsEvents: true,
 *     repositoryUpdateEvents: true,
 *     enableSslVerification: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.SystemHook("example",
 *     url="https://example.com/hook-%d",
 *     token="secret-token",
 *     push_events=True,
 *     tag_push_events=True,
 *     merge_requests_events=True,
 *     repository_update_events=True,
 *     enable_ssl_verification=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.SystemHook("example", new()
 *     {
 *         Url = "https://example.com/hook-%d",
 *         Token = "secret-token",
 *         PushEvents = true,
 *         TagPushEvents = true,
 *         MergeRequestsEvents = true,
 *         RepositoryUpdateEvents = true,
 *         EnableSslVerification = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewSystemHook(ctx, "example", &gitlab.SystemHookArgs{
 * 			Url:                    pulumi.String("https://example.com/hook-%d"),
 * 			Token:                  pulumi.String("secret-token"),
 * 			PushEvents:             pulumi.Bool(true),
 * 			TagPushEvents:          pulumi.Bool(true),
 * 			MergeRequestsEvents:    pulumi.Bool(true),
 * 			RepositoryUpdateEvents: pulumi.Bool(true),
 * 			EnableSslVerification:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.SystemHook;
 * import com.pulumi.gitlab.SystemHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SystemHook("example", SystemHookArgs.builder()
 *             .url("https://example.com/hook-%d")
 *             .token("secret-token")
 *             .pushEvents(true)
 *             .tagPushEvents(true)
 *             .mergeRequestsEvents(true)
 *             .repositoryUpdateEvents(true)
 *             .enableSslVerification(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:SystemHook
 *     properties:
 *       url: https://example.com/hook-%d
 *       token: secret-token
 *       pushEvents: true
 *       tagPushEvents: true
 *       mergeRequestsEvents: true
 *       repositoryUpdateEvents: true
 *       enableSslVerification: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a system hook using the hook id `{hook-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/systemHook:SystemHook example 42
 * ```
 * NOTE: the `token` attribute won't be available for imported resources.
 * @property enableSslVerification Do SSL verification when triggering the hook.
 * @property mergeRequestsEvents Trigger hook on merge requests events.
 * @property pushEvents When true, the hook fires on push events.
 * @property repositoryUpdateEvents Trigger hook on repository update events.
 * @property tagPushEvents When true, the hook fires on new tags being pushed.
 * @property token Secret token to validate received payloads; this isn’t returned in the response. This attribute is not available for imported resources.
 * @property url The hook URL.
 */
public data class SystemHookArgs(
    public val enableSslVerification: Output<Boolean>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val repositoryUpdateEvents: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val token: Output<String>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.SystemHookArgs> {
    override fun toJava(): com.pulumi.gitlab.SystemHookArgs =
        com.pulumi.gitlab.SystemHookArgs.builder()
            .enableSslVerification(enableSslVerification?.applyValue({ args0 -> args0 }))
            .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
            .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
            .repositoryUpdateEvents(repositoryUpdateEvents?.applyValue({ args0 -> args0 }))
            .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
            .token(token?.applyValue({ args0 -> args0 }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SystemHookArgs].
 */
@PulumiTagMarker
public class SystemHookArgsBuilder internal constructor() {
    private var enableSslVerification: Output<Boolean>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var pushEvents: Output<Boolean>? = null

    private var repositoryUpdateEvents: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var token: Output<String>? = null

    private var url: Output<String>? = null

    /**
     * @param value Do SSL verification when triggering the hook.
     */
    @JvmName("pjfxgcalsbgqcdco")
    public suspend fun enableSslVerification(`value`: Output<Boolean>) {
        this.enableSslVerification = value
    }

    /**
     * @param value Trigger hook on merge requests events.
     */
    @JvmName("axtevthowjbxhcto")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value When true, the hook fires on push events.
     */
    @JvmName("nfcvwulfavojjoqi")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Trigger hook on repository update events.
     */
    @JvmName("lxnodkyrqckkkkko")
    public suspend fun repositoryUpdateEvents(`value`: Output<Boolean>) {
        this.repositoryUpdateEvents = value
    }

    /**
     * @param value When true, the hook fires on new tags being pushed.
     */
    @JvmName("eqlauxpgbrgyrdjk")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value Secret token to validate received payloads; this isn’t returned in the response. This attribute is not available for imported resources.
     */
    @JvmName("ssbuguivytodldgm")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The hook URL.
     */
    @JvmName("hmchalupbnqonarf")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Do SSL verification when triggering the hook.
     */
    @JvmName("yamivxnuytnnurwh")
    public suspend fun enableSslVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value Trigger hook on merge requests events.
     */
    @JvmName("mreknakdjaeowygj")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value When true, the hook fires on push events.
     */
    @JvmName("fmtutkquonfpnqro")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Trigger hook on repository update events.
     */
    @JvmName("jnjkkxcojgbttsvt")
    public suspend fun repositoryUpdateEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryUpdateEvents = mapped
    }

    /**
     * @param value When true, the hook fires on new tags being pushed.
     */
    @JvmName("xodffsurfktksema")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value Secret token to validate received payloads; this isn’t returned in the response. This attribute is not available for imported resources.
     */
    @JvmName("ipjbwcmsrgifeise")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The hook URL.
     */
    @JvmName("hivdephvhdbamrlv")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): SystemHookArgs = SystemHookArgs(
        enableSslVerification = enableSslVerification,
        mergeRequestsEvents = mergeRequestsEvents,
        pushEvents = pushEvents,
        repositoryUpdateEvents = repositoryUpdateEvents,
        tagPushEvents = tagPushEvents,
        token = token,
        url = url,
    )
}
