@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.TagProtectionAllowedToCreate
import com.pulumi.gitlab.kotlin.outputs.TagProtectionAllowedToCreate.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [TagProtection].
 */
@PulumiTagMarker
public class TagProtectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagProtectionArgs = TagProtectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagProtectionArgsBuilder.() -> Unit) {
        val builder = TagProtectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TagProtection {
        val builtJavaResource = com.pulumi.gitlab.TagProtection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TagProtection(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const tagProtect = new gitlab.TagProtection("TagProtect", {
 *     project: "12345",
 *     tag: "TagProtected",
 *     createAccessLevel: "developer",
 *     allowedToCreates: [
 *         {
 *             userId: 42,
 *         },
 *         {
 *             groupId: 43,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * tag_protect = gitlab.TagProtection("TagProtect",
 *     project="12345",
 *     tag="TagProtected",
 *     create_access_level="developer",
 *     allowed_to_creates=[
 *         {
 *             "user_id": 42,
 *         },
 *         {
 *             "group_id": 43,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagProtect = new GitLab.TagProtection("TagProtect", new()
 *     {
 *         Project = "12345",
 *         Tag = "TagProtected",
 *         CreateAccessLevel = "developer",
 *         AllowedToCreates = new[]
 *         {
 *             new GitLab.Inputs.TagProtectionAllowedToCreateArgs
 *             {
 *                 UserId = 42,
 *             },
 *             new GitLab.Inputs.TagProtectionAllowedToCreateArgs
 *             {
 *                 GroupId = 43,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewTagProtection(ctx, "TagProtect", &gitlab.TagProtectionArgs{
 * 			Project:           pulumi.String("12345"),
 * 			Tag:               pulumi.String("TagProtected"),
 * 			CreateAccessLevel: pulumi.String("developer"),
 * 			AllowedToCreates: gitlab.TagProtectionAllowedToCreateArray{
 * 				&gitlab.TagProtectionAllowedToCreateArgs{
 * 					UserId: pulumi.Int(42),
 * 				},
 * 				&gitlab.TagProtectionAllowedToCreateArgs{
 * 					GroupId: pulumi.Int(43),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.TagProtection;
 * import com.pulumi.gitlab.TagProtectionArgs;
 * import com.pulumi.gitlab.inputs.TagProtectionAllowedToCreateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagProtect = new TagProtection("tagProtect", TagProtectionArgs.builder()
 *             .project("12345")
 *             .tag("TagProtected")
 *             .createAccessLevel("developer")
 *             .allowedToCreates(
 *                 TagProtectionAllowedToCreateArgs.builder()
 *                     .userId(42)
 *                     .build(),
 *                 TagProtectionAllowedToCreateArgs.builder()
 *                     .groupId(43)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tagProtect:
 *     type: gitlab:TagProtection
 *     name: TagProtect
 *     properties:
 *       project: '12345'
 *       tag: TagProtected
 *       createAccessLevel: developer
 *       allowedToCreates:
 *         - userId: 42
 *         - groupId: 43
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Tag protections can be imported using an id made up of `project_id:tag_name`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/tagProtection:TagProtection example 123456789:v1.0.0
 * ```
 */
public class TagProtection internal constructor(
    override val javaResource: com.pulumi.gitlab.TagProtection,
) : KotlinCustomResource(javaResource, TagProtectionMapper) {
    /**
     * Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    public val allowedToCreates: Output<List<TagProtectionAllowedToCreate>>?
        get() = javaResource.allowedToCreates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Access levels allowed to create. Default value of `maintainer`. The default value is always sent if not provided in the configuration. Valid values are: `no one`, `developer`, `maintainer`.
     */
    public val createAccessLevel: Output<String>
        get() = javaResource.createAccessLevel().applyValue({ args0 -> args0 })

    /**
     * The id of the project.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Name of the tag or wildcard.
     */
    public val tag: Output<String>
        get() = javaResource.tag().applyValue({ args0 -> args0 })
}

public object TagProtectionMapper : ResourceMapper<TagProtection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.TagProtection::class == javaResource::class

    override fun map(javaResource: Resource): TagProtection = TagProtection(
        javaResource as
            com.pulumi.gitlab.TagProtection,
    )
}

/**
 * @see [TagProtection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagProtection].
 */
public suspend fun tagProtection(
    name: String,
    block: suspend TagProtectionResourceBuilder.() -> Unit,
): TagProtection {
    val builder = TagProtectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagProtection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagProtection(name: String): TagProtection {
    val builder = TagProtectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
