@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.TagProtectionArgs.builder
import com.pulumi.gitlab.kotlin.inputs.TagProtectionAllowedToCreateArgs
import com.pulumi.gitlab.kotlin.inputs.TagProtectionAllowedToCreateArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const tagProtect = new gitlab.TagProtection("TagProtect", {
 *     project: "12345",
 *     tag: "TagProtected",
 *     createAccessLevel: "developer",
 *     allowedToCreates: [
 *         {
 *             userId: 42,
 *         },
 *         {
 *             groupId: 43,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * tag_protect = gitlab.TagProtection("TagProtect",
 *     project="12345",
 *     tag="TagProtected",
 *     create_access_level="developer",
 *     allowed_to_creates=[
 *         {
 *             "user_id": 42,
 *         },
 *         {
 *             "group_id": 43,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagProtect = new GitLab.TagProtection("TagProtect", new()
 *     {
 *         Project = "12345",
 *         Tag = "TagProtected",
 *         CreateAccessLevel = "developer",
 *         AllowedToCreates = new[]
 *         {
 *             new GitLab.Inputs.TagProtectionAllowedToCreateArgs
 *             {
 *                 UserId = 42,
 *             },
 *             new GitLab.Inputs.TagProtectionAllowedToCreateArgs
 *             {
 *                 GroupId = 43,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewTagProtection(ctx, "TagProtect", &gitlab.TagProtectionArgs{
 * 			Project:           pulumi.String("12345"),
 * 			Tag:               pulumi.String("TagProtected"),
 * 			CreateAccessLevel: pulumi.String("developer"),
 * 			AllowedToCreates: gitlab.TagProtectionAllowedToCreateArray{
 * 				&gitlab.TagProtectionAllowedToCreateArgs{
 * 					UserId: pulumi.Int(42),
 * 				},
 * 				&gitlab.TagProtectionAllowedToCreateArgs{
 * 					GroupId: pulumi.Int(43),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.TagProtection;
 * import com.pulumi.gitlab.TagProtectionArgs;
 * import com.pulumi.gitlab.inputs.TagProtectionAllowedToCreateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagProtect = new TagProtection("tagProtect", TagProtectionArgs.builder()
 *             .project("12345")
 *             .tag("TagProtected")
 *             .createAccessLevel("developer")
 *             .allowedToCreates(
 *                 TagProtectionAllowedToCreateArgs.builder()
 *                     .userId(42)
 *                     .build(),
 *                 TagProtectionAllowedToCreateArgs.builder()
 *                     .groupId(43)
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tagProtect:
 *     type: gitlab:TagProtection
 *     name: TagProtect
 *     properties:
 *       project: '12345'
 *       tag: TagProtected
 *       createAccessLevel: developer
 *       allowedToCreates:
 *         - userId: 42
 *         - groupId: 43
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Tag protections can be imported using an id made up of `project_id:tag_name`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/tagProtection:TagProtection example 123456789:v1.0.0
 * ```
 * @property allowedToCreates Array of access levels/user(s)/group(s) allowed to create protected tags.
 * @property createAccessLevel Access levels allowed to create. Default value of `maintainer`. The default value is always sent if not provided in the configuration. Valid values are: `no one`, `developer`, `maintainer`.
 * @property project The id of the project.
 * @property tag Name of the tag or wildcard.
 */
public data class TagProtectionArgs(
    public val allowedToCreates: Output<List<TagProtectionAllowedToCreateArgs>>? = null,
    public val createAccessLevel: Output<String>? = null,
    public val project: Output<String>? = null,
    public val tag: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.TagProtectionArgs> {
    override fun toJava(): com.pulumi.gitlab.TagProtectionArgs =
        com.pulumi.gitlab.TagProtectionArgs.builder()
            .allowedToCreates(
                allowedToCreates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .createAccessLevel(createAccessLevel?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .tag(tag?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagProtectionArgs].
 */
@PulumiTagMarker
public class TagProtectionArgsBuilder internal constructor() {
    private var allowedToCreates: Output<List<TagProtectionAllowedToCreateArgs>>? = null

    private var createAccessLevel: Output<String>? = null

    private var project: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("xypyisniwmafkwxi")
    public suspend fun allowedToCreates(`value`: Output<List<TagProtectionAllowedToCreateArgs>>) {
        this.allowedToCreates = value
    }

    @JvmName("tipuebsskfyojiwn")
    public suspend fun allowedToCreates(vararg values: Output<TagProtectionAllowedToCreateArgs>) {
        this.allowedToCreates = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("utbioqljjudjypdo")
    public suspend fun allowedToCreates(values: List<Output<TagProtectionAllowedToCreateArgs>>) {
        this.allowedToCreates = Output.all(values)
    }

    /**
     * @param value Access levels allowed to create. Default value of `maintainer`. The default value is always sent if not provided in the configuration. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("lvbkyddsyekkwdra")
    public suspend fun createAccessLevel(`value`: Output<String>) {
        this.createAccessLevel = value
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("lgbxviaxnwcdlaeh")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Name of the tag or wildcard.
     */
    @JvmName("uhfihpitppnrghis")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("uscqkoicetovgmkk")
    public suspend fun allowedToCreates(`value`: List<TagProtectionAllowedToCreateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToCreates = mapped
    }

    /**
     * @param argument Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("niykaxluhcimjyug")
    public suspend fun allowedToCreates(argument: List<suspend TagProtectionAllowedToCreateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TagProtectionAllowedToCreateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToCreates = mapped
    }

    /**
     * @param argument Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("onqrejufnqhebjys")
    public suspend fun allowedToCreates(vararg argument: suspend TagProtectionAllowedToCreateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TagProtectionAllowedToCreateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToCreates = mapped
    }

    /**
     * @param argument Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("mynadkscuphrmjdv")
    public suspend fun allowedToCreates(argument: suspend TagProtectionAllowedToCreateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TagProtectionAllowedToCreateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allowedToCreates = mapped
    }

    /**
     * @param values Array of access levels/user(s)/group(s) allowed to create protected tags.
     */
    @JvmName("akciibjurqaqsbdd")
    public suspend fun allowedToCreates(vararg values: TagProtectionAllowedToCreateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToCreates = mapped
    }

    /**
     * @param value Access levels allowed to create. Default value of `maintainer`. The default value is always sent if not provided in the configuration. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("afyestskmxccegmr")
    public suspend fun createAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createAccessLevel = mapped
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("xpjqbjrqipmhwrpi")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Name of the tag or wildcard.
     */
    @JvmName("yapespaatjgeiabo")
    public suspend fun tag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): TagProtectionArgs = TagProtectionArgs(
        allowedToCreates = allowedToCreates,
        createAccessLevel = createAccessLevel,
        project = project,
        tag = tag,
    )
}
