@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.TopicArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.Topic` resource allows to manage the lifecycle of topics that are then assignable to projects.
 * > Topics are the successors for project tags. Aside from avoiding terminology collisions with Git tags, they are more descriptive and better searchable.
 * > Deleting a topic was implemented in GitLab 14.9. For older versions of GitLab set `soft_destroy = true` to empty out a topic instead of deleting it.
 * **Upstream API**: [GitLab REST API docs for topics](https://docs.gitlab.com/ee/api/topics.html)
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/topic:Topic You can import a topic to terraform state using `<resource> <id>`.
 * ```
 * The `id` must be an integer for the id of the topic you want to import,
 * for example:
 * ```sh
 * $ pulumi import gitlab:index/topic:Topic functional_programming 1
 * ```
 * @property avatar A local path to the avatar image to upload. **Note**: not available for imported resources.
 * @property avatarHash The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
 * @property description A text describing the topic.
 * @property name The topic's name.
 * @property softDestroy Empty the topics fields instead of deleting it.
 * @property title The topic's description. Requires at least GitLab 15.0 for which it's a required argument.
 */
public data class TopicArgs(
    public val avatar: Output<String>? = null,
    public val avatarHash: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    @Deprecated(
        message = """
  GitLab 14.9 introduced the proper deletion of topics. This field is no longer needed.
  """,
    )
    public val softDestroy: Output<Boolean>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.TopicArgs> {
    override fun toJava(): com.pulumi.gitlab.TopicArgs = com.pulumi.gitlab.TopicArgs.builder()
        .avatar(avatar?.applyValue({ args0 -> args0 }))
        .avatarHash(avatarHash?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .softDestroy(softDestroy?.applyValue({ args0 -> args0 }))
        .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TopicArgs].
 */
@PulumiTagMarker
public class TopicArgsBuilder internal constructor() {
    private var avatar: Output<String>? = null

    private var avatarHash: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var softDestroy: Output<Boolean>? = null

    private var title: Output<String>? = null

    /**
     * @param value A local path to the avatar image to upload. **Note**: not available for imported resources.
     */
    @JvmName("gjtohlniysclkgft")
    public suspend fun avatar(`value`: Output<String>) {
        this.avatar = value
    }

    /**
     * @param value The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
     */
    @JvmName("pgbkbtbxjcvdiwya")
    public suspend fun avatarHash(`value`: Output<String>) {
        this.avatarHash = value
    }

    /**
     * @param value A text describing the topic.
     */
    @JvmName("jceldwsgwymdcjge")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The topic's name.
     */
    @JvmName("tyfqlelehxpehldo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Empty the topics fields instead of deleting it.
     */
    @Deprecated(
        message = """
  GitLab 14.9 introduced the proper deletion of topics. This field is no longer needed.
  """,
    )
    @JvmName("ouhnfnsgbblbyyih")
    public suspend fun softDestroy(`value`: Output<Boolean>) {
        this.softDestroy = value
    }

    /**
     * @param value The topic's description. Requires at least GitLab 15.0 for which it's a required argument.
     */
    @JvmName("rbgsuxjhmkatuwdr")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value A local path to the avatar image to upload. **Note**: not available for imported resources.
     */
    @JvmName("tnmltbyyxduoyuyl")
    public suspend fun avatar(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avatar = mapped
    }

    /**
     * @param value The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
     */
    @JvmName("alfilkixnilefmst")
    public suspend fun avatarHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avatarHash = mapped
    }

    /**
     * @param value A text describing the topic.
     */
    @JvmName("poemxlrksoslqxjx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The topic's name.
     */
    @JvmName("gfimqfeeixvclbsy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Empty the topics fields instead of deleting it.
     */
    @Deprecated(
        message = """
  GitLab 14.9 introduced the proper deletion of topics. This field is no longer needed.
  """,
    )
    @JvmName("tpnwdregibyqqutq")
    public suspend fun softDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDestroy = mapped
    }

    /**
     * @param value The topic's description. Requires at least GitLab 15.0 for which it's a required argument.
     */
    @JvmName("mummxeessdwnecbk")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): TopicArgs = TopicArgs(
        avatar = avatar,
        avatarHash = avatarHash,
        description = description,
        name = name,
        softDestroy = softDestroy,
        title = title,
    )
}
