@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.UserCustomAttributeArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.UserCustomAttribute` resource allows to manage custom attributes for a user.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const attr = new gitlab.UserCustomAttribute("attr", {
 *     user: 42,
 *     key: "location",
 *     value: "Greenland",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * attr = gitlab.UserCustomAttribute("attr",
 *     user=42,
 *     key="location",
 *     value="Greenland")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attr = new GitLab.UserCustomAttribute("attr", new()
 *     {
 *         User = 42,
 *         Key = "location",
 *         Value = "Greenland",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewUserCustomAttribute(ctx, "attr", &gitlab.UserCustomAttributeArgs{
 * 			User:  pulumi.Int(42),
 * 			Key:   pulumi.String("location"),
 * 			Value: pulumi.String("Greenland"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.UserCustomAttribute;
 * import com.pulumi.gitlab.UserCustomAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attr = new UserCustomAttribute("attr", UserCustomAttributeArgs.builder()
 *             .user("42")
 *             .key("location")
 *             .value("Greenland")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attr:
 *     type: gitlab:UserCustomAttribute
 *     properties:
 *       user: '42'
 *       key: location
 *       value: Greenland
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a user custom attribute using an id made up of `{user-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/userCustomAttribute:UserCustomAttribute attr 42:location
 * ```
 * @property key Key for the Custom Attribute.
 * @property user The id of the user.
 * @property value Value for the Custom Attribute.
 */
public data class UserCustomAttributeArgs(
    public val key: Output<String>? = null,
    public val user: Output<Int>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.UserCustomAttributeArgs> {
    override fun toJava(): com.pulumi.gitlab.UserCustomAttributeArgs =
        com.pulumi.gitlab.UserCustomAttributeArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserCustomAttributeArgs].
 */
@PulumiTagMarker
public class UserCustomAttributeArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var user: Output<Int>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("nnetcnclasyhjltr")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("jhbdgwvamrtdrovt")
    public suspend fun user(`value`: Output<Int>) {
        this.user = value
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("anudamncfospkyhr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("keiisxohimcaikfo")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("xxvltvxeplpolqkq")
    public suspend fun user(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("hkrqixclfdhoxfby")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): UserCustomAttributeArgs = UserCustomAttributeArgs(
        key = key,
        user = user,
        `value` = `value`,
    )
}
