@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserGpgKey].
 */
@PulumiTagMarker
public class UserGpgKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGpgKeyArgs = UserGpgKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGpgKeyArgsBuilder.() -> Unit) {
        val builder = UserGpgKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserGpgKey {
        val builtJavaResource = com.pulumi.gitlab.UserGpgKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGpgKey(builtJavaResource)
    }
}

/**
 * The `gitlab.UserGpgKey` resource allows to manage the lifecycle of a GPG key assigned to the current user or a specific user.
 * > Managing GPG keys for arbitrary users requires admin privileges.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#get-a-specific-gpg-key)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = gitlab.getUser({
 *     username: "example-user",
 * });
 * // Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 * const exampleUserGpgKey = new gitlab.UserGpgKey("example", {
 *     userId: example.then(example => example.id),
 *     key: `-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----`,
 * });
 * // Manages a GPG key for the current user
 * const exampleUser = new gitlab.UserGpgKey("example_user", {key: `-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----`});
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.get_user(username="example-user")
 * # Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 * example_user_gpg_key = gitlab.UserGpgKey("example",
 *     user_id=example.id,
 *     key="""-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----""")
 * # Manages a GPG key for the current user
 * example_user = gitlab.UserGpgKey("example_user", key="""-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----""")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = GitLab.GetUser.Invoke(new()
 *     {
 *         Username = "example-user",
 *     });
 *     // Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 *     var exampleUserGpgKey = new GitLab.UserGpgKey("example", new()
 *     {
 *         UserId = example.Apply(getUserResult => getUserResult.Id),
 *         Key = @"-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----",
 *     });
 *     // Manages a GPG key for the current user
 *     var exampleUser = new GitLab.UserGpgKey("example_user", new()
 *     {
 *         Key = @"-----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.LookupUser(ctx, &gitlab.LookupUserArgs{
 * 			Username: pulumi.StringRef("example-user"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 * 		_, err = gitlab.NewUserGpgKey(ctx, "example", &gitlab.UserGpgKeyArgs{
 * 			UserId: pulumi.String(example.Id),
 * 			Key:    pulumi.String("-----BEGIN PGP PUBLIC KEY BLOCK-----\n...\n-----END PGP PUBLIC KEY BLOCK-----"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Manages a GPG key for the current user
 * 		_, err = gitlab.NewUserGpgKey(ctx, "example_user", &gitlab.UserGpgKeyArgs{
 * 			Key: pulumi.String("-----BEGIN PGP PUBLIC KEY BLOCK-----\n...\n-----END PGP PUBLIC KEY BLOCK-----"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GitlabFunctions;
 * import com.pulumi.gitlab.inputs.GetUserArgs;
 * import com.pulumi.gitlab.UserGpgKey;
 * import com.pulumi.gitlab.UserGpgKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = GitlabFunctions.getUser(GetUserArgs.builder()
 *             .username("example-user")
 *             .build());
 *         // Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 *         var exampleUserGpgKey = new UserGpgKey("exampleUserGpgKey", UserGpgKeyArgs.builder()
 *             .userId(example.applyValue(getUserResult -> getUserResult.id()))
 *             .key("""
 * -----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----            """)
 *             .build());
 *         // Manages a GPG key for the current user
 *         var exampleUser = new UserGpgKey("exampleUser", UserGpgKeyArgs.builder()
 *             .key("""
 * -----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * -----END PGP PUBLIC KEY BLOCK-----            """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Manages a GPG key for the specified user. An admin token is required if `user_id` is specified.
 *   exampleUserGpgKey:
 *     type: gitlab:UserGpgKey
 *     name: example
 *     properties:
 *       userId: ${example.id}
 *       key: |-
 *         -----BEGIN PGP PUBLIC KEY BLOCK-----
 *         ...
 *         -----END PGP PUBLIC KEY BLOCK-----
 *   # Manages a GPG key for the current user
 *   exampleUser:
 *     type: gitlab:UserGpgKey
 *     name: example_user
 *     properties:
 *       key: |-
 *         -----BEGIN PGP PUBLIC KEY BLOCK-----
 *         ...
 *         -----END PGP PUBLIC KEY BLOCK-----
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: gitlab:getUser
 *       Arguments:
 *         username: example-user
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a GPG key for a specific user using an id made up of `{user-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/userGpgKey:UserGpgKey example 42:1
 * ```
 * Alternatively, you can import a GPG key for the current user using an id made up of `{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/userGpgKey:UserGpgKey example_user 1
 * ```
 */
public class UserGpgKey internal constructor(
    override val javaResource: com.pulumi.gitlab.UserGpgKey,
) : KotlinCustomResource(javaResource, UserGpgKeyMapper) {
    /**
     * The time when this key was created in GitLab.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The armored GPG public key.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The ID of the GPG key.
     */
    public val keyId: Output<Int>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * The ID of the user to add the GPG key to. If this field is omitted, this resource manages a GPG key for the current user. Otherwise, this resource manages a GPG key for the specified user, and an admin token is required.
     */
    public val userId: Output<Int>?
        get() = javaResource.userId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object UserGpgKeyMapper : ResourceMapper<UserGpgKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.UserGpgKey::class == javaResource::class

    override fun map(javaResource: Resource): UserGpgKey = UserGpgKey(
        javaResource as
            com.pulumi.gitlab.UserGpgKey,
    )
}

/**
 * @see [UserGpgKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGpgKey].
 */
public suspend fun userGpgKey(name: String, block: suspend UserGpgKeyResourceBuilder.() -> Unit): UserGpgKey {
    val builder = UserGpgKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGpgKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGpgKey(name: String): UserGpgKey {
    val builder = UserGpgKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
