@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.UserImpersonationTokenArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.UserImpersonationToken` resource allows to manage impersonation tokens of users.
 * Requires administrator access. Token values are returned once. You are only able to create impersonation tokens to impersonate the user and perform both API calls and Git reads and writes. The user can’t see these tokens in their profile settings page.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#create-an-impersonation-token)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const _this = new gitlab.UserImpersonationToken("this", {
 *     userId: 12345,
 *     name: "token_name",
 *     scopes: ["api"],
 *     expiresAt: "2024-08-27",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * this = gitlab.UserImpersonationToken("this",
 *     user_id=12345,
 *     name="token_name",
 *     scopes=["api"],
 *     expires_at="2024-08-27")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new GitLab.UserImpersonationToken("this", new()
 *     {
 *         UserId = 12345,
 *         Name = "token_name",
 *         Scopes = new[]
 *         {
 *             "api",
 *         },
 *         ExpiresAt = "2024-08-27",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewUserImpersonationToken(ctx, "this", &gitlab.UserImpersonationTokenArgs{
 * 			UserId: pulumi.Int(12345),
 * 			Name:   pulumi.String("token_name"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("api"),
 * 			},
 * 			ExpiresAt: pulumi.String("2024-08-27"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.UserImpersonationToken;
 * import com.pulumi.gitlab.UserImpersonationTokenArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new UserImpersonationToken("this", UserImpersonationTokenArgs.builder()
 *             .userId(12345)
 *             .name("token_name")
 *             .scopes("api")
 *             .expiresAt("2024-08-27")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: gitlab:UserImpersonationToken
 *     properties:
 *       userId: 12345
 *       name: token_name
 *       scopes:
 *         - api
 *       expiresAt: 2024-08-27
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab User Impersonation Token can be imported using a key composed of `<user-id>:<token-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/userImpersonationToken:UserImpersonationToken example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 * @property expiresAt Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
 * @property name The name of the impersonation token.
 * @property scopes Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_service_ping`
 * @property userId The ID of the user.
 */
public data class UserImpersonationTokenArgs(
    public val expiresAt: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.UserImpersonationTokenArgs> {
    override fun toJava(): com.pulumi.gitlab.UserImpersonationTokenArgs =
        com.pulumi.gitlab.UserImpersonationTokenArgs.builder()
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserImpersonationTokenArgs].
 */
@PulumiTagMarker
public class UserImpersonationTokenArgsBuilder internal constructor() {
    private var expiresAt: Output<String>? = null

    private var name: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
     */
    @JvmName("purfwejravletgvd")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The name of the impersonation token.
     */
    @JvmName("icjgxlcdqipjuadf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_service_ping`
     */
    @JvmName("pcamitcyjwmvlxwd")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("kfskthaclxaerqku")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_service_ping`
     */
    @JvmName("gbtyyrlqgspnhvxg")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The ID of the user.
     */
    @JvmName("tvkwdgvomdwwkfql")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
     */
    @JvmName("auotoqotjcxhsrfk")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The name of the impersonation token.
     */
    @JvmName("ibhphasjjpedddtv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_service_ping`
     */
    @JvmName("bfnvywkwkhhlqmqq")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_service_ping`
     */
    @JvmName("fiviwjeceogcqcpw")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The ID of the user.
     */
    @JvmName("itlyxagkgqovtple")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserImpersonationTokenArgs = UserImpersonationTokenArgs(
        expiresAt = expiresAt,
        name = name,
        scopes = scopes,
        userId = userId,
    )
}
