@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [UserRunner].
 */
@PulumiTagMarker
public class UserRunnerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserRunnerArgs = UserRunnerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserRunnerArgsBuilder.() -> Unit) {
        val builder = UserRunnerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserRunner {
        val builtJavaResource = com.pulumi.gitlab.UserRunner(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserRunner(builtJavaResource)
    }
}

/**
 * The `gitlab.UserRunner` resource allows creating a GitLab runner using the new [GitLab Runner Registration Flow](https://docs.gitlab.com/ee/ci/runners/new_creation_workflow.html).
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#create-a-runner)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Create a project runner
 * const projectRunner = new gitlab.UserRunner("project_runner", {
 *     runnerType: "project_type",
 *     projectId: 123456,
 *     description: "A runner created using a user access token instead of a registration token",
 *     tagLists: [
 *         "a-tag",
 *         "other-tag",
 *     ],
 *     untagged: true,
 * });
 * // Create a group runner
 * const groupRunner = new gitlab.UserRunner("group_runner", {
 *     runnerType: "group_type",
 *     groupId: 123456,
 * });
 * // Create a instance runner
 * const instanceRunner = new gitlab.UserRunner("instance_runner", {runnerType: "instance_type"});
 * const configToml = pulumi.interpolate`concurrent = 1
 * check_interval = 0
 * [session_server]
 *   session_timeout = 1800
 * [[runners]]
 *   name = "my_gitlab_runner"
 *   url = "https://example.gitlab.com"
 *   token = "${groupRunner.token}"
 *   executor = "docker"
 *   [runners&#46;custom_build_dir]
 *   [runners&#46;cache]
 *     [runners&#46;cache&#46;s3]
 *     [runners&#46;cache&#46;gcs]
 *     [runners&#46;cache&#46;azure]
 *   [runners&#46;docker]
 *     tls_verify = false
 *     image = "ubuntu"
 *     privileged = true
 *     disable_entrypoint_overwrite = false
 *     oom_kill_disable = false
 *     disable_cache = false
 *     volumes = ["/cache", "/certs/client"]
 *     shm_size = 0
 * `;
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Create a project runner
 * project_runner = gitlab.UserRunner("project_runner",
 *     runner_type="project_type",
 *     project_id=123456,
 *     description="A runner created using a user access token instead of a registration token",
 *     tag_lists=[
 *         "a-tag",
 *         "other-tag",
 *     ],
 *     untagged=True)
 * # Create a group runner
 * group_runner = gitlab.UserRunner("group_runner",
 *     runner_type="group_type",
 *     group_id=123456)
 * # Create a instance runner
 * instance_runner = gitlab.UserRunner("instance_runner", runner_type="instance_type")
 * config_toml = group_runner.token.apply(lambda token: f"""concurrent = 1
 * check_interval = 0
 * [session_server]
 *   session_timeout = 1800
 * [[runners]]
 *   name = "my_gitlab_runner"
 *   url = "https://example.gitlab.com"
 *   token = "{token}"
 *   executor = "docker"
 *   [runners&#46;custom_build_dir]
 *   [runners&#46;cache]
 *     [runners&#46;cache&#46;s3]
 *     [runners&#46;cache&#46;gcs]
 *     [runners&#46;cache&#46;azure]
 *   [runners&#46;docker]
 *     tls_verify = false
 *     image = "ubuntu"
 *     privileged = true
 *     disable_entrypoint_overwrite = false
 *     oom_kill_disable = false
 *     disable_cache = false
 *     volumes = ["/cache", "/certs/client"]
 *     shm_size = 0
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a project runner
 *     var projectRunner = new GitLab.UserRunner("project_runner", new()
 *     {
 *         RunnerType = "project_type",
 *         ProjectId = 123456,
 *         Description = "A runner created using a user access token instead of a registration token",
 *         TagLists = new[]
 *         {
 *             "a-tag",
 *             "other-tag",
 *         },
 *         Untagged = true,
 *     });
 *     // Create a group runner
 *     var groupRunner = new GitLab.UserRunner("group_runner", new()
 *     {
 *         RunnerType = "group_type",
 *         GroupId = 123456,
 *     });
 *     // Create a instance runner
 *     var instanceRunner = new GitLab.UserRunner("instance_runner", new()
 *     {
 *         RunnerType = "instance_type",
 *     });
 *     var configToml = groupRunner.Token.Apply(token => @$"concurrent = 1
 * check_interval = 0
 * [session_server]
 *   session_timeout = 1800
 * [[runners]]
 *   name = ""my_gitlab_runner""
 *   url = ""https://example.gitlab.com""
 *   token = ""{token}""
 *   executor = ""docker""
 *   [runners&#46;custom_build_dir]
 *   [runners&#46;cache]
 *     [runners&#46;cache&#46;s3]
 *     [runners&#46;cache&#46;gcs]
 *     [runners&#46;cache&#46;azure]
 *   [runners&#46;docker]
 *     tls_verify = false
 *     image = ""ubuntu""
 *     privileged = true
 *     disable_entrypoint_overwrite = false
 *     oom_kill_disable = false
 *     disable_cache = false
 *     volumes = [""/cache"", ""/certs/client""]
 *     shm_size = 0
 * ");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a project runner
 * 		_, err := gitlab.NewUserRunner(ctx, "project_runner", &gitlab.UserRunnerArgs{
 * 			RunnerType:  pulumi.String("project_type"),
 * 			ProjectId:   pulumi.Int(123456),
 * 			Description: pulumi.String("A runner created using a user access token instead of a registration token"),
 * 			TagLists: pulumi.StringArray{
 * 				pulumi.String("a-tag"),
 * 				pulumi.String("other-tag"),
 * 			},
 * 			Untagged: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Create a group runner
 * 		groupRunner, err := gitlab.NewUserRunner(ctx, "group_runner", &gitlab.UserRunnerArgs{
 * 			RunnerType: pulumi.String("group_type"),
 * 			GroupId:    pulumi.Int(123456),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Create a instance runner
 * 		_, err = gitlab.NewUserRunner(ctx, "instance_runner", &gitlab.UserRunnerArgs{
 * 			RunnerType: pulumi.String("instance_type"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_ = groupRunner.Token.ApplyT(func(token string) (string, error) {
 * 			return fmt.Sprintf(`concurrent = 1
 * check_interval = 0
 * [session_server]
 *   session_timeout = 1800
 * [[runners]]
 *   name = "my_gitlab_runner"
 *   url = "https://example.gitlab.com"
 *   token = "%v"
 *   executor = "docker"
 *   [runners&#46;custom_build_dir]
 *   [runners&#46;cache]
 *     [runners&#46;cache&#46;s3]
 *     [runners&#46;cache&#46;gcs]
 *     [runners&#46;cache&#46;azure]
 *   [runners&#46;docker]
 *     tls_verify = false
 *     image = "ubuntu"
 *     privileged = true
 *     disable_entrypoint_overwrite = false
 *     oom_kill_disable = false
 *     disable_cache = false
 *     volumes = ["/cache", "/certs/client"]
 *     shm_size = 0
 * `, token), nil
 * 		}).(pulumi.StringOutput)
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.UserRunner;
 * import com.pulumi.gitlab.UserRunnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a project runner
 *         var projectRunner = new UserRunner("projectRunner", UserRunnerArgs.builder()
 *             .runnerType("project_type")
 *             .projectId(123456)
 *             .description("A runner created using a user access token instead of a registration token")
 *             .tagLists(
 *                 "a-tag",
 *                 "other-tag")
 *             .untagged(true)
 *             .build());
 *         // Create a group runner
 *         var groupRunner = new UserRunner("groupRunner", UserRunnerArgs.builder()
 *             .runnerType("group_type")
 *             .groupId(123456)
 *             .build());
 *         // Create a instance runner
 *         var instanceRunner = new UserRunner("instanceRunner", UserRunnerArgs.builder()
 *             .runnerType("instance_type")
 *             .build());
 *         final var configToml = groupRunner.token().applyValue(token -> """
 * concurrent = 1
 * check_interval = 0
 * [session_server]
 *   session_timeout = 1800
 * [[runners]]
 *   name = "my_gitlab_runner"
 *   url = "https://example.gitlab.com"
 *   token = "%s"
 *   executor = "docker"
 *   [runners&#46;custom_build_dir]
 *   [runners&#46;cache]
 *     [runners&#46;cache&#46;s3]
 *     [runners&#46;cache&#46;gcs]
 *     [runners&#46;cache&#46;azure]
 *   [runners&#46;docker]
 *     tls_verify = false
 *     image = "ubuntu"
 *     privileged = true
 *     disable_entrypoint_overwrite = false
 *     oom_kill_disable = false
 *     disable_cache = false
 *     volumes = ["/cache", "/certs/client"]
 *     shm_size = 0
 * ", token));
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a project runner
 *   projectRunner:
 *     type: gitlab:UserRunner
 *     name: project_runner
 *     properties:
 *       runnerType: project_type
 *       projectId: 123456
 *       description: A runner created using a user access token instead of a registration token
 *       tagLists:
 *         - a-tag
 *         - other-tag
 *       untagged: true
 *   # Create a group runner
 *   groupRunner:
 *     type: gitlab:UserRunner
 *     name: group_runner
 *     properties:
 *       runnerType: group_type
 *       groupId: 123456 # populate other attributes...
 *   # Create a instance runner
 *   instanceRunner:
 *     type: gitlab:UserRunner
 *     name: instance_runner
 *     properties:
 *       runnerType: instance_type
 * variables:
 *   configToml: |
 *     concurrent = 1
 *     check_interval = 0
 *     [session_server]
 *       session_timeout = 1800
 *     [[runners]]
 *       name = "my_gitlab_runner"
 *       url = "https://example.gitlab.com"
 *       token = "${groupRunner.token}"
 *       executor = "docker"
 *       [runners&#46;custom_build_dir]
 *       [runners&#46;cache]
 *         [runners&#46;cache&#46;s3]
 *         [runners&#46;cache&#46;gcs]
 *         [runners&#46;cache&#46;azure]
 *       [runners&#46;docker]
 *         tls_verify = false
 *         image = "ubuntu"
 *         privileged = true
 *         disable_entrypoint_overwrite = false
 *         oom_kill_disable = false
 *         disable_cache = false
 *         volumes = ["/cache", "/certs/client"]
 *         shm_size = 0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a gitlab runner using its ID
 * Note: Importing a runner will not provide access to the `token` attribute
 * ```sh
 * $ pulumi import gitlab:index/userRunner:UserRunner example 12345
 * ```
 */
public class UserRunner internal constructor(
    override val javaResource: com.pulumi.gitlab.UserRunner,
) : KotlinCustomResource(javaResource, UserRunnerMapper) {
    /**
     * The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * Description of the runner.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The ID of the group that the runner is created in. Required if runner*type is group*type.
     */
    public val groupId: Output<Int>?
        get() = javaResource.groupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies if the runner should be locked for the current project.
     */
    public val locked: Output<Boolean>
        get() = javaResource.locked().applyValue({ args0 -> args0 })

    /**
     * Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
     */
    public val maximumTimeout: Output<Int>
        get() = javaResource.maximumTimeout().applyValue({ args0 -> args0 })

    /**
     * Specifies if the runner should ignore new jobs.
     */
    public val paused: Output<Boolean>
        get() = javaResource.paused().applyValue({ args0 -> args0 })

    /**
     * The ID of the project that the runner is created in. Required if runner*type is project*type.
     */
    public val projectId: Output<Int>?
        get() = javaResource.projectId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
     */
    public val runnerType: Output<String>
        get() = javaResource.runnerType().applyValue({ args0 -> args0 })

    /**
     * A list of runner tags.
     */
    public val tagLists: Output<List<String>>
        get() = javaResource.tagLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * Specifies if the runner should handle untagged jobs.
     */
    public val untagged: Output<Boolean>
        get() = javaResource.untagged().applyValue({ args0 -> args0 })
}

public object UserRunnerMapper : ResourceMapper<UserRunner> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.UserRunner::class == javaResource::class

    override fun map(javaResource: Resource): UserRunner = UserRunner(
        javaResource as
            com.pulumi.gitlab.UserRunner,
    )
}

/**
 * @see [UserRunner].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserRunner].
 */
public suspend fun userRunner(name: String, block: suspend UserRunnerResourceBuilder.() -> Unit): UserRunner {
    val builder = UserRunnerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserRunner].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userRunner(name: String): UserRunner {
    val builder = UserRunnerResourceBuilder()
    builder.name(name)
    return builder.build()
}
