@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserSshKey].
 */
@PulumiTagMarker
public class UserSshKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserSshKeyArgs = UserSshKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserSshKeyArgsBuilder.() -> Unit) {
        val builder = UserSshKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserSshKey {
        val builtJavaResource = com.pulumi.gitlab.UserSshKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserSshKey(builtJavaResource)
    }
}

/**
 * The `gitlab.UserSshKey` resource allows to manage the lifecycle of an SSH key assigned to a user.
 * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/users.html#single-ssh-key)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = gitlab.getUser({
 *     username: "example-user",
 * });
 * const exampleUserSshKey = new gitlab.UserSshKey("example", {
 *     userId: example.then(example => example.id),
 *     title: "example-key",
 *     key: "ssh-ed25519 AAAA...",
 *     expiresAt: "2016-01-21T00:00:00.000Z",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.get_user(username="example-user")
 * example_user_ssh_key = gitlab.UserSshKey("example",
 *     user_id=example.id,
 *     title="example-key",
 *     key="ssh-ed25519 AAAA...",
 *     expires_at="2016-01-21T00:00:00.000Z")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = GitLab.GetUser.Invoke(new()
 *     {
 *         Username = "example-user",
 *     });
 *     var exampleUserSshKey = new GitLab.UserSshKey("example", new()
 *     {
 *         UserId = example.Apply(getUserResult => getUserResult.Id),
 *         Title = "example-key",
 *         Key = "ssh-ed25519 AAAA...",
 *         ExpiresAt = "2016-01-21T00:00:00.000Z",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.LookupUser(ctx, &gitlab.LookupUserArgs{
 * 			Username: pulumi.StringRef("example-user"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewUserSshKey(ctx, "example", &gitlab.UserSshKeyArgs{
 * 			UserId:    pulumi.String(example.Id),
 * 			Title:     pulumi.String("example-key"),
 * 			Key:       pulumi.String("ssh-ed25519 AAAA..."),
 * 			ExpiresAt: pulumi.String("2016-01-21T00:00:00.000Z"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GitlabFunctions;
 * import com.pulumi.gitlab.inputs.GetUserArgs;
 * import com.pulumi.gitlab.UserSshKey;
 * import com.pulumi.gitlab.UserSshKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = GitlabFunctions.getUser(GetUserArgs.builder()
 *             .username("example-user")
 *             .build());
 *         var exampleUserSshKey = new UserSshKey("exampleUserSshKey", UserSshKeyArgs.builder()
 *             .userId(example.applyValue(getUserResult -> getUserResult.id()))
 *             .title("example-key")
 *             .key("ssh-ed25519 AAAA...")
 *             .expiresAt("2016-01-21T00:00:00.000Z")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleUserSshKey:
 *     type: gitlab:UserSshKey
 *     name: example
 *     properties:
 *       userId: ${example.id}
 *       title: example-key
 *       key: ssh-ed25519 AAAA...
 *       expiresAt: 2016-01-21T00:00:00.000Z
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: gitlab:getUser
 *       Arguments:
 *         username: example-user
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a user ssh key using an id made up of `{user-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/userSshKey:UserSshKey example 42:1
 * ```
 */
public class UserSshKey internal constructor(
    override val javaResource: com.pulumi.gitlab.UserSshKey,
) : KotlinCustomResource(javaResource, UserSshKeyMapper) {
    /**
     * The time when this key was created in GitLab.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The expiration date of the SSH key in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ)
     */
    public val expiresAt: Output<String>?
        get() = javaResource.expiresAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ssh key. The SSH key `comment` (trailing part) is optional and ignored for diffing, because GitLab overrides it with the username and GitLab hostname.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The ID of the ssh key.
     */
    public val keyId: Output<Int>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * The title of the ssh key.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })

    /**
     * The ID or username of the user. If this field is omitted, this resource manages a SSH key for the current user. Otherwise, this resource manages a SSH key for the specified user, and an admin token is required.
     */
    public val userId: Output<Int>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object UserSshKeyMapper : ResourceMapper<UserSshKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.UserSshKey::class == javaResource::class

    override fun map(javaResource: Resource): UserSshKey = UserSshKey(
        javaResource as
            com.pulumi.gitlab.UserSshKey,
    )
}

/**
 * @see [UserSshKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserSshKey].
 */
public suspend fun userSshKey(name: String, block: suspend UserSshKeyResourceBuilder.() -> Unit): UserSshKey {
    val builder = UserSshKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserSshKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userSshKey(name: String): UserSshKey {
    val builder = UserSshKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
