@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowForcePush Allow force push for all users with push access.
 * @property allowedToMerges An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
 * @property allowedToPushes An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
 * @property developerCanInitialPush Allow developers to initial push.
 */
public data class ApplicationSettingsDefaultBranchProtectionDefaultsArgs(
    public val allowForcePush: Output<Boolean>? = null,
    public val allowedToMerges: Output<List<Any>>? = null,
    public val allowedToPushes: Output<List<Any>>? = null,
    public val developerCanInitialPush: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.gitlab.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgs =
        com.pulumi.gitlab.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgs.builder()
            .allowForcePush(allowForcePush?.applyValue({ args0 -> args0 }))
            .allowedToMerges(allowedToMerges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedToPushes(allowedToPushes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .developerCanInitialPush(developerCanInitialPush?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationSettingsDefaultBranchProtectionDefaultsArgs].
 */
@PulumiTagMarker
public class ApplicationSettingsDefaultBranchProtectionDefaultsArgsBuilder internal constructor() {
    private var allowForcePush: Output<Boolean>? = null

    private var allowedToMerges: Output<List<Any>>? = null

    private var allowedToPushes: Output<List<Any>>? = null

    private var developerCanInitialPush: Output<Boolean>? = null

    /**
     * @param value Allow force push for all users with push access.
     */
    @JvmName("gpxuxhieloydkrcm")
    public suspend fun allowForcePush(`value`: Output<Boolean>) {
        this.allowForcePush = value
    }

    /**
     * @param value An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("bwxllelxgijsjtxr")
    public suspend fun allowedToMerges(`value`: Output<List<Any>>) {
        this.allowedToMerges = value
    }

    @JvmName("rhdplcxyappsejmh")
    public suspend fun allowedToMerges(vararg values: Output<Any>) {
        this.allowedToMerges = Output.all(values.asList())
    }

    /**
     * @param values An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("saldwuglulbixqkh")
    public suspend fun allowedToMerges(values: List<Output<Any>>) {
        this.allowedToMerges = Output.all(values)
    }

    /**
     * @param value An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("mabvkwanidrbxlaq")
    public suspend fun allowedToPushes(`value`: Output<List<Any>>) {
        this.allowedToPushes = value
    }

    @JvmName("msqphjqxbordjsdq")
    public suspend fun allowedToPushes(vararg values: Output<Any>) {
        this.allowedToPushes = Output.all(values.asList())
    }

    /**
     * @param values An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("shpvasosywtnufpp")
    public suspend fun allowedToPushes(values: List<Output<Any>>) {
        this.allowedToPushes = Output.all(values)
    }

    /**
     * @param value Allow developers to initial push.
     */
    @JvmName("rdyanbjdlkplhacv")
    public suspend fun developerCanInitialPush(`value`: Output<Boolean>) {
        this.developerCanInitialPush = value
    }

    /**
     * @param value Allow force push for all users with push access.
     */
    @JvmName("mwtlmpxghiqcjfdi")
    public suspend fun allowForcePush(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForcePush = mapped
    }

    /**
     * @param value An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("sfchuvodcukpnvgq")
    public suspend fun allowedToMerges(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param values An array of access levels allowed to merge. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("qmxaofqfysqjcxyj")
    public suspend fun allowedToMerges(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param value An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("tlforsoglmbtkgpf")
    public suspend fun allowedToPushes(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param values An array of access levels allowed to push. Supports Developer (30) or Maintainer (40).
     */
    @JvmName("enukrcacqisuonbo")
    public suspend fun allowedToPushes(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param value Allow developers to initial push.
     */
    @JvmName("sveyfryglqjblvuf")
    public suspend fun developerCanInitialPush(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.developerCanInitialPush = mapped
    }

    internal fun build(): ApplicationSettingsDefaultBranchProtectionDefaultsArgs =
        ApplicationSettingsDefaultBranchProtectionDefaultsArgs(
            allowForcePush = allowForcePush,
            allowedToMerges = allowedToMerges,
            allowedToPushes = allowedToPushes,
            developerCanInitialPush = developerCanInitialPush,
        )
}
