@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.inputs.BranchProtectionAllowedToPushArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessLevel Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
 * @property accessLevelDescription Readable description of access level.
 * @property groupId The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
 * @property userId The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
 */
public data class BranchProtectionAllowedToPushArgs(
    public val accessLevel: Output<String>? = null,
    public val accessLevelDescription: Output<String>? = null,
    public val groupId: Output<Int>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.BranchProtectionAllowedToPushArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.BranchProtectionAllowedToPushArgs =
        com.pulumi.gitlab.inputs.BranchProtectionAllowedToPushArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .accessLevelDescription(accessLevelDescription?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BranchProtectionAllowedToPushArgs].
 */
@PulumiTagMarker
public class BranchProtectionAllowedToPushArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var accessLevelDescription: Output<String>? = null

    private var groupId: Output<Int>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("ldbnlehnwgmathya")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value Readable description of access level.
     */
    @JvmName("rjpsjynjoovkidpa")
    public suspend fun accessLevelDescription(`value`: Output<String>) {
        this.accessLevelDescription = value
    }

    /**
     * @param value The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
     */
    @JvmName("hodumhgiudnkktll")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
     */
    @JvmName("wdjaoabgiwdiewuj")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("wrhmavsnhubqydkt")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value Readable description of access level.
     */
    @JvmName("tnssuhloirrcucic")
    public suspend fun accessLevelDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevelDescription = mapped
    }

    /**
     * @param value The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
     */
    @JvmName("njmhqvmisemptyyk")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
     */
    @JvmName("cbwccxeccqheucft")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): BranchProtectionAllowedToPushArgs = BranchProtectionAllowedToPushArgs(
        accessLevel = accessLevel,
        accessLevelDescription = accessLevelDescription,
        groupId = groupId,
        userId = userId,
    )
}
