@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplication.
 * @property id
 */
public data class GetApplicationPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetApplicationPlainArgs =
        com.pulumi.gitlab.inputs.GetApplicationPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value
     */
    @JvmName("hlgcvptxkskcuxjq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
