@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetBranchPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBranch.
 * @property name The name of the branch.
 * @property project The full path or id of the project.
 */
public data class GetBranchPlainArgs(
    public val name: String,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetBranchPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetBranchPlainArgs =
        com.pulumi.gitlab.inputs.GetBranchPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBranchPlainArgs].
 */
@PulumiTagMarker
public class GetBranchPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var project: String? = null

    /**
     * @param value The name of the branch.
     */
    @JvmName("rofwivcdhnhdoucw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The full path or id of the project.
     */
    @JvmName("qlwxrhwdupoewrst")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetBranchPlainArgs = GetBranchPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
