@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin.inputs

import com.pulumi.gitlab.inputs.GetClusterAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterAgent.
 * @property agentId The ID of the agent.
 * @property project ID or full path of the project maintained by the authenticated user.
 */
public data class GetClusterAgentPlainArgs(
    public val agentId: Int,
    public val project: String,
) : ConvertibleToJava<com.pulumi.gitlab.inputs.GetClusterAgentPlainArgs> {
    override fun toJava(): com.pulumi.gitlab.inputs.GetClusterAgentPlainArgs =
        com.pulumi.gitlab.inputs.GetClusterAgentPlainArgs.builder()
            .agentId(agentId.let({ args0 -> args0 }))
            .project(project.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterAgentPlainArgs].
 */
@PulumiTagMarker
public class GetClusterAgentPlainArgsBuilder internal constructor() {
    private var agentId: Int? = null

    private var project: String? = null

    /**
     * @param value The ID of the agent.
     */
    @JvmName("hyfhfouslydlmcsd")
    public suspend fun agentId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentId = mapped
    }

    /**
     * @param value ID or full path of the project maintained by the authenticated user.
     */
    @JvmName("tqgkepbpaqkuetuc")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.project = mapped
    }

    internal fun build(): GetClusterAgentPlainArgs = GetClusterAgentPlainArgs(
        agentId = agentId ?: throw PulumiNullFieldException("agentId"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
